﻿using Siger.ApiQMS.Result;
using Siger.Middlelayer.Log;
using System.Diagnostics;

namespace Siger.ApiQMS.Utility
{
    public class PythonBIAbnormalHelper
    {
        public string result = string.Empty;
        public string GetAbnormlRuleCheck(string pythonPath, string pythonScriptPath, string methodName, RequestQMSDynamicDiag param)
        {
            var p = new Process();
            var sArguments = $"{pythonScriptPath}";
            sArguments += $" {methodName}";
            sArguments += $" {param.itemID}";
            sArguments += $" {param.UCL}";
            sArguments += $" {param.LCL}";
            sArguments += $" {param.traceID}";
            sArguments += $" {param.value}";
            sArguments += $" {param.rule1}";
            sArguments += $" {param.rule2}";
            sArguments += $" {param.rule3}";
            sArguments += $" {param.rule4}";
            sArguments += $" {param.rule5}";
            sArguments += $" {param.rule6}";
            sArguments += $" {param.rule7}";
            sArguments += $" {param.rule8}";

            p.StartInfo.FileName = pythonPath; //python的安装路径
            p.StartInfo.Arguments = sArguments;//python命令的参数
            p.StartInfo.UseShellExecute = false;
            p.StartInfo.RedirectStandardOutput = true;
            p.StartInfo.RedirectStandardInput = true;
            p.StartInfo.RedirectStandardError = true;
            p.StartInfo.CreateNoWindow = true;
            result = "";
            p.Start();//启动进程            
            p.BeginOutputReadLine();
            p.BeginErrorReadLine();
            p.OutputDataReceived += p_OutputDataReceived;
            p.ErrorDataReceived += P_ErrorDataReceived;
            p.WaitForExit();

            return result;
        }

        public string GetCpkHist(string pythonPath, string pythonScriptPath, string methodName, RequestQmsDynamicHistParams param)
        {
            var p = new Process();
            var sArguments = $"{pythonScriptPath}";
            sArguments += $" {methodName}";
            sArguments += $" {param.itemID}";
            sArguments += $" {param.UCL}";
            sArguments += $" {param.LCL}";
            sArguments += $" {param.value}";

            p.StartInfo.FileName = pythonPath; //python的安装路径
            p.StartInfo.Arguments = sArguments;//python命令的参数
            p.StartInfo.UseShellExecute = false;
            p.StartInfo.RedirectStandardOutput = true;
            p.StartInfo.RedirectStandardInput = true;
            p.StartInfo.RedirectStandardError = true;
            p.StartInfo.CreateNoWindow = true;
            result = "";
            p.Start();//启动进程            
            p.BeginOutputReadLine();
            p.BeginErrorReadLine();
            p.OutputDataReceived += p_OutputDataReceived;
            p.ErrorDataReceived += P_ErrorDataReceived;
            p.WaitForExit();

            return result;
        }

        private void P_ErrorDataReceived(object sender, DataReceivedEventArgs e)
        {
            if (!string.IsNullOrEmpty(e.Data))
            {
                Logger.WriteLineError(e.Data);
                result = "";
            }
        }

        private void p_OutputDataReceived(object sender, DataReceivedEventArgs e)
        {
            if (!string.IsNullOrEmpty(e.Data))
            {
                result = e.Data;
            }
        }
    }
}
