﻿using System;
using System.Globalization;
using System.Reflection;
using System.Text;
using System.Threading;

namespace Siger.ApiQMS.Utility
{
    public static class UtilsHelper
    {
        internal static int GetLocaleCodePage()
        {
            return Thread.CurrentThread.CurrentCulture.TextInfo.ANSICodePage;
        }

        internal static CultureInfo GetCultureInfo()
        {
            return Thread.CurrentThread.CurrentCulture;
        }

        internal static char[] m_achIntlSpace = new char[2]
        {    
            ' ',
            '　'
        };

        internal static Encoding GetFileIOEncoding()
        {
            return Encoding.Default;
        }

        /// <summary>返回一个 <see langword="Integer" /> 值，它包含变量的数据类型分类。</summary>
        /// <param name="VarName">必需。 <see langword="Object" /> 变量。 如果 <see langword="Option Strict" /> 为 <see langword="Off" />，则可以传递除结构之外的任何数据类型的变量。</param>
        /// <returns>返回一个 <see langword="Integer" /> 值，它包含变量的数据类型分类。</returns>
        public static VariantType VarType(object VarName)
        {
            return VarName != null ? VarTypeFromComType(VarName.GetType()) : VariantType.Object;
        }

        internal static VariantType VarTypeFromComType(Type typ)
        {
            VariantType variantType1;
            if ((object)typ == null)
                variantType1 = VariantType.Object;
            else if (typ.IsArray)
            {
                typ = typ.GetElementType();
                if (typ.IsArray)
                {
                    variantType1 = VariantType.Object | VariantType.Array;
                }
                else
                {
                    VariantType variantType2 = VarTypeFromComType(typ);
                    variantType1 = (variantType2 & VariantType.Array) == VariantType.Empty ? variantType2 | VariantType.Array : VariantType.Object | VariantType.Array;
                }
            }
            else
            {
                if (typ.IsEnum)
                    typ = Enum.GetUnderlyingType(typ);
                if ((object)typ == null)
                {
                    variantType1 = VariantType.Empty;
                }
                else
                {
                    switch (Type.GetTypeCode(typ))
                    {
                        case TypeCode.DBNull:
                            variantType1 = VariantType.Null;
                            break;
                        case TypeCode.Boolean:
                            variantType1 = VariantType.Boolean;
                            break;
                        case TypeCode.Char:
                            variantType1 = VariantType.Char;
                            break;
                        case TypeCode.Byte:
                            variantType1 = VariantType.Byte;
                            break;
                        case TypeCode.Int16:
                            variantType1 = VariantType.Short;
                            break;
                        case TypeCode.Int32:
                            variantType1 = VariantType.Integer;
                            break;
                        case TypeCode.Int64:
                            variantType1 = VariantType.Long;
                            break;
                        case TypeCode.Single:
                            variantType1 = VariantType.Single;
                            break;
                        case TypeCode.Double:
                            variantType1 = VariantType.Double;
                            break;
                        case TypeCode.Decimal:
                            variantType1 = VariantType.Decimal;
                            break;
                        case TypeCode.DateTime:
                            variantType1 = VariantType.Date;
                            break;
                        case TypeCode.String:
                            variantType1 = VariantType.String;
                            break;
                        default:
                            variantType1 = (object)typ == (object)typeof(Missing) || (object)typ == (object)typeof(Exception) || typ.IsSubclassOf(typeof(Exception)) ? VariantType.Error : (!typ.IsValueType ? VariantType.Object : VariantType.UserDefinedType);
                            break;
                    }
                }
            }
            return variantType1;
        }
    }
}
