﻿using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon;

namespace Siger.ApiTPM.Controllers
{
    [Route("tpm/[controller]/[action]")]
    public class BaseController : AuthController
    {
        [HttpGet]
        public string GetCategory(int severity_level)
        {
            // 1->润滑；2->检查；3->紧缩；4->清洁；5->调整；6->更换；10->电气；11->机械；12->TS；13->设施
            var severityLevel = string.Empty;
            switch (severity_level)
            {
                case 1:
                    severityLevel = "润滑";
                    break;
                case 2:
                    severityLevel = "检查";
                    break;
                case 3:
                    severityLevel = "紧缩";
                    break;
                case 4:
                    severityLevel = "清洁";
                    break;
                case 5:
                    severityLevel = "调整";
                    break;
                case 6:
                    severityLevel = "更换";
                    break;
                case 10:
                    severityLevel = "电气";
                    break;
                case 11:
                    severityLevel = "机械";
                    break;
                case 12:
                    severityLevel = "TS";
                    break;
                case 13:
                    severityLevel = "设施";
                    break;
            }

            return severityLevel;
        }
        [HttpGet]
        public string GetCostName(int cost)
        {
            //1: "维修保养",
            //2: "生产换型",
            //3: "操作/调整不良",
            //4: "工装/调整不良",
            //5: "项目/改造试车",
            //6: "新产品",
            //7: "撞车",
            //8: "维修备件质量",
            //9: "公用工程",
            //10: "热机",
            //11: "公共设施故障",
            //12: "其他"
            var name = string.Empty;
            switch (cost)
            {
                case 1:
                    name = "维修保养";
                    break;
                case 2:
                    name = "生产换型";
                    break;
                case 3:
                    name = "操作/调整不良";
                    break;
                case 4:
                    name = "工装/调整不良";
                    break;
                case 5:
                    name = "项目/改造试车";
                    break;
                case 6:
                    name = "新产品";
                    break;
                case 7:
                    name = "撞车";
                    break;
                case 8:
                    name = "维修备件质量";
                    break;
                case 9:
                    name = "公用工程";
                    break;
                case 10:
                    name = "热机";
                    break;
                case 11:
                    name = "公共设施故障";
                    break;
                case 12:
                    name = "其他";
                    break;
            }

            return name;
        }
    }
}