﻿using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;

namespace Siger.ApiTPM.Controllers
{
    public class MachineCheckController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly IProjectCheckRepository _checkRepository;

        public MachineCheckController(IUnitOfWork unitOfWork, IProjectCheckRepository checkRepository)
        {
            _unitOfWork = unitOfWork;
            _checkRepository = checkRepository;
        }

        [HttpGet]
        public IActionResult GetMachineStatusLists(int machinestatus, int machinetypeid, int sectionid, int page = 1,
            int pagesize = 10)
        {
            var data = _checkRepository.GetPagedMachineChecks(machinestatus, machinetypeid, sectionid, ProjectId, page,
                pagesize);


            return new PagedObjectResult(data.Data, data.Total, page, pagesize);
        }
    }
}