﻿using Siger.Middlelayer.Repository.Data.Tpm;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiTPM.Result
{
    public class AppPlanResultResult : TpmResultBase
    {
        public int ret { get; set; } = 1;

        public string msg { get; set; } = string.Empty;

        public PlanListList data { get; set; } = new PlanListList();

        public AppPlanResultResult()
        {
            data = new PlanListList();
        }
    }

    public class PlanListList
    {
        public string location { get; set; }

        public int count { get; set; }

        public int standard_time { get; set; } = 0;

        public string machine_person { get; set; }

        public List<PlanListModel> planlist { get; set; }
    }

    public class PlanListModel
    {
        public int id { get; set; }

        public int ptimeid { get; set; }

        public int planid { get; set; }

        public int itemid { get; set; }

        public int type { get; set; }

        public int typeid { get; set; }

        public int machineid { get; set; }

        public string content { get; set; }

        public int value_type { get; set; }

        public int mode { get; set; }

        public string unit { get; set; }

        public string up_limit { get; set; }

        public string lower_limit { get; set; }

        public int severity_level { get; set; }

        public int standard_time { get; set; }

        public int instruction_cycle { get; set; }

        public int instruction_mid { get; set; }

        public string yeartime { get; set; }

        public string failure_mode { get; set; }

        public string result_demo_url { get; set; }

        public string remark { get; set; }

        public string work_instruction_url { get; set; }

        public string work_instruction_name { get; set; }

        public int overdue { get; set; }

        public int makeself { get; set; }

        public int create_mid { get; set; }

        public string create_time { get; set; }

        public string Location { get; set; }


        public string keep_remark { get; set; }

        public int hit_type { get; set; }

        public string maintain_tool { get; set; }

        public string maintain_sparepart { get; set; }

        public string hit_item { get; set; }

        public string maintain_method { get; set; }
    }

    public class ResponsePlanPunctual
    {
        public List<string> dimensions { get; set; }

        public List<PlanPuntualModel> source { get; set; } = new List<PlanPuntualModel>();
    }

    public class PlanPuntualModel
    {
        public string w { get; set; }

        public int plannum { get; set; }

        public int executenum { get; set; }
    }

    public class AppPlanHistoryResult : TpmResultBase
    {
        public int ret { get; set; } = 1;

        public string msg { get; set; } = string.Empty;

        public PlanHistoryInfoList data { get; set; }

        public AppPlanHistoryResult()
        {
            data = new PlanHistoryInfoList();
        }
    }

    public class PlanHistoryInfoList
    {
        public int standard_time { get; set; } = 0;

        public string Location { get; set; } = string.Empty;

        public int count { get; set; } = 0;

        public string machine_person { get; set; }

        public List<PlanHistoryInfoModel> planlist = new List<PlanHistoryInfoModel>();
    }

    public class PlanHistoryInfoModel
    {
        public int id { get; set; }

        public int ptimeid { get; set; }

        public int planid { get; set; }

        public int type { get; set; }

        public int typeid { get; set; }

        public int machineid { get; set; }

        public string content { get; set; }

        public int value_type { get; set; }

        public int mode { get; set; }

        public string unit { get; set; }

        public string up_limit { get; set; }

        public string lower_limit { get; set; }

        public int severity_level { get; set; }

        public int instruction_cycle { get; set; }

        public int instruction_mid { get; set; }

        public string failure_mode { get; set; }

        public string result_demo_url { get; set; }

        public string remark { get; set; }

        public string work_instruction_url { get; set; }

        public string work_instruction_name { get; set; }

        public int overdue { get; set; }

        public int makeself { get; set; }

        public int create_mid { get; set; }

        public string actual_time { get; set; }

        public string imgurl { get; set; }

        public string sparepartids { get; set; }

        public string sparepartout { get; set; }

        /// <summary>
        /// value_type =1 类型为 bool value_type =2 类型为string
        /// </summary>
        public string value { get; set; }

        public string yeartime { get; set; }

        public string username { get; set; }


        public string keep_remark { get; set; }

        public int hit_type { get; set; }

        public string maintain_tool { get; set; }

        public string maintain_sparepart { get; set; }

        public string hit_item { get; set; }

        public string maintain_method { get; set; }

        public int standard_time { get; set; }

        public string corepairer { get; set; }

        public string corepairer_names { get; set; }
    }

    public class ResponseGetMaintainPlan
    {
        public int planid { get; set; }

        public string name { get; set; }

        public int status { get; set; }
    }
}
