﻿using System;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository;
using System.Collections.Generic;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Repositories.Interface;
using Siger.Middlelayer.ToolRepository.Request;
using Siger.Middlelayer.Utility.Helpers;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.ApiTools.Controllers
{
    public class AlertSettingController : BaseController
    {
        private ISigerToolSendMessagetypeRepository _sigerToolSendMessagetypeRepository;
        private ISigerProjectToolEmailConfigRepository sigerProjectToolEmailConfigRepository;
        private ISigerProjectEmailConfig _sigerProjectEmailConfig;
        private ISigerProjectEmailMachine _sigerProjectEmailMachine;
      
        private ISigerProjectUserRepository _sigerProjectUser;

        private IUnitOfWork _unitOfWork;

        public AlertSettingController(ISigerToolSendMessagetypeRepository sigerToolSendMessagetypeRepository, ISigerProjectToolEmailConfigRepository sigerProjectToolEmailConfigRepository, ISigerProjectEmailConfig sigerProjectEmailConfig,
            ISigerProjectEmailMachine sigerProjectEmailMachine , ISigerProjectUserRepository sigerProjectUser , IUnitOfWork unitOfWork)
        {
            _sigerToolSendMessagetypeRepository = sigerToolSendMessagetypeRepository;
            this.sigerProjectToolEmailConfigRepository = sigerProjectToolEmailConfigRepository;
            _sigerProjectEmailConfig = sigerProjectEmailConfig;
            _sigerProjectEmailMachine = sigerProjectEmailMachine;

            _sigerProjectUser = sigerProjectUser;
            _unitOfWork = unitOfWork;
        }

        [HttpGet]
        public IActionResult GetEmailInfos()
        {
            var result = sigerProjectToolEmailConfigRepository.GetList(f => f.projectid == ProjectId).FirstOrDefault();
            if (result == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }
            return new ObjectResult(result);
        }
        /// <summary>
        /// 报警邮箱配置 -已配置人员
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetSettingEmailUsers()
        {
            var settingEmails = sigerProjectToolEmailConfigRepository.GetSettingEmailUsers(ProjectId);

            return new ObjectResult(settingEmails);

        }

        [HttpGet]
        public IActionResult GetCommunicationList(int? sectionid ,int page=1, int pagesize=10)
        {
            var result = _sigerToolSendMessagetypeRepository.GetCommunicationList(sectionid, ProjectId, page, pagesize,out int totalCount);
            foreach(var d in result)
            {
                d.section_dsc = _sigerProjectEmailConfig.GetLineLevelTitlebByMachine(d.mid,ProjectId);
            }
            return new PagedObjectResult(result, totalCount, page, pagesize);
        }

        /// <summary>
        /// 获取报警通讯详情
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetAlertSettingCommunicationDetail(int cid,int pid,int mid,string spindle,string tn,string pn)
        {
            var messageTypeDetail = _sigerToolSendMessagetypeRepository.GetAlertSettingCommunicationDetail(cid,pid, mid,spindle,tn,pn);
            return new ObjectResult(messageTypeDetail);
        }

        /// <summary>
        /// 报警通讯配置
        /// </summary>
        /// <param name="req"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult AlertSettingCommunicationEdit([FromBody]RequestAlertSettingCommunicationEdit req)
        {
            //移除检测
            ////检测value
            //var data = req.value.Split(',');
            //if(data.Count()!=3)
            //{
            //    throw new BadRequestException(RequestEnum.InputValueError);
            //}
            //else
            //{
            //    foreach (var item in data)
            //    {
            //        if (item.Count() != 5)
            //        {
            //            throw new BadRequestException(RequestEnum.InputValueError);
            //        }
            //    }
            //    if(data[0].Any(f=>f!='0'&&f!='1'))
            //    {
            //        throw new BadRequestException(RequestEnum.InputValueError);
            //    }
            //    if (data[1].Any(f => f != '0' && f != '1'))
            //    {
            //        throw new BadRequestException(RequestEnum.InputValueError);
            //    }
            //    if (data[2].Any(f => f != '0' && f != '1' && f != '2'))
            //    {
            //        throw new BadRequestException(RequestEnum.InputValueError);
            //    }
            //}
            _sigerToolSendMessagetypeRepository.AlertSettingCommunicationEdit(CompanyId,ProjectId, req.mid, req.spindle, req.tn, req.pn, req.value);

            return Ok();
        }



    }
}