﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Dapper;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Request;
using Siger.Middlelayer.ToolRepository.Repositories.Interface;
using Siger.Middlelayer.ToolRepository.Response;

namespace Siger.ApiTools.Controllers
{

    public class ReportPushController : BaseController
    {
        ISigerProjectToolSpindleTrueRepository _sigerProjectToolSpindleTrueRepository;
        ISigerProjectToolcutterLocationalarmRepository _sigerProjectToolcutterLocationalarmRepository;

        private const int Cid = 52;
        private const int Pid = 85;
        public ReportPushController(ISigerProjectToolSpindleTrueRepository sigerProjectToolSpindleTrue, ISigerProjectToolcutterLocationalarmRepository sigerProjectToolcutterLocationalarm)
        {
            _sigerProjectToolSpindleTrueRepository = sigerProjectToolSpindleTrue;
            _sigerProjectToolcutterLocationalarmRepository = sigerProjectToolcutterLocationalarm;
        }
        [NoTokenValidateFilter]
        [HttpPost]
        public ActionResult GetToolAlarmLogInfo([FromBody]RequestToolAlarmLogInfo request)
        {

            var machinelist = _sigerProjectToolcutterLocationalarmRepository.GetMachineIds(request.sectionid, Pid);
            var dapperData = new ToolAlarmRepository(Cid, Pid);
            var pageInfo = new Pagination(1, 1000);
            var stime = UnixTimeHelper.ConvertDataTimeLong(request.begin);
            var etime = UnixTimeHelper.ConvertDataTimeLong(request.end);

            var data = dapperData.GetPagedToolAlarm(pageInfo, machinelist.ToList(), stime, etime, (int)AlarmGrade.Destroyed);
            var machinesCode = _sigerProjectToolSpindleTrueRepository.GetMachine(Pid, request.sectionid);
            var listResult = new List<ResponseGetToolAlarmLogInfo>();

            foreach (var obj in data.Value)
            {
                listResult.Add(new ResponseGetToolAlarmLogInfo
                {
                    machine_id = obj.machine_id,
                    machine_code = machinesCode.Find(f => f.MachineId == obj.machine_id).MachineCode,
                    machine_name = machinesCode.Find(f => f.MachineId == obj.machine_id).MachineTitle,
                    spindle_name = obj.spindle_name,
                    cutter_location_name = obj.cutter_location_name,
                    program_no = obj.program_no,
                    alarm_grade = obj.alarm_grade,
                    error_msg = EnumHelper.GetEnumDesc((AlarmGrade)obj.alarm_grade),
                    alarmtime = obj.alarmtime,
                    alarm_time = UnixTimeHelper.ConvertIntDateTime(obj.alarmtime)
                });
            }
            return new ObjectResult(listResult);

        }
    }
}