﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Redis.Model;
using Siger.Middlelayer.Redis.Repositories;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.ToolRepository.Entities;
using Siger.Middlelayer.ToolRepository.Repositories.Interface;
using Siger.Middlelayer.ToolRepository.Request;

namespace Siger.ApiTools.Controllers
{
    public class ToolAlertSettingController : BaseController
    {
        IUnitOfWork unitOfWork;
        ISigerProjectToolCutterLocationTrueRepository _sigerProjectToolCutterLocationTrueRepository;
        ISigerProjectToolAlertConditionRepository sigerProjectToolAlertConditionRepository;

        public ToolAlertSettingController(IUnitOfWork unitOfWork, ISigerProjectToolCutterLocationTrueRepository sigerProjectToolCutterLocationTrueRepository, ISigerProjectToolAlertConditionRepository sigerProjectToolAlertConditionRepository)
        {
            this.unitOfWork = unitOfWork;
            _sigerProjectToolCutterLocationTrueRepository = sigerProjectToolCutterLocationTrueRepository;
            this.sigerProjectToolAlertConditionRepository = sigerProjectToolAlertConditionRepository;
        }

        [HttpPost]
        public IActionResult SetCutterLocationAlarmSetting()
        {
            var result = _sigerProjectToolCutterLocationTrueRepository.SetCutterLocationAlarmSetting(ProjectId);
            if (result)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }

            throw new BadRequestException(CommonEnum.Fail);
        }

        [HttpPost]
        public IActionResult GetCutterLocationAlarmSetting([FromBody]RequestGetCutterLocationAlarmSetting req)
        {
            var data = _sigerProjectToolCutterLocationTrueRepository.GetCutterLocationAlarmSetting(req.sectionid,
                ProjectId, req.page, req.pagesize,out int toalCount);
            return new PagedObjectResult(data, toalCount, req.page, req.pagesize);
        }
        [HttpGet]
        public IActionResult GetAlertSettingInfo(int id)
        {
            return new ObjectResult(sigerProjectToolAlertConditionRepository.GetAlertSettingInfo(id));
        }

        [HttpPost]
        public IActionResult ToolConfigAlertSetting([FromBody]RequestToolConfigAlertSetting req)
        {
            //清空原来的配置
            var oldData = sigerProjectToolAlertConditionRepository.GetList(f=>f.cutterlocationid==req.cutterlocationid).Select(f=>f.id).ToList();
            oldData.ForEach(x =>
                {
                    sigerProjectToolAlertConditionRepository.Delete(x) ;
                });
            //新增配置
            var data = new List<SigerProjectToolAlertCondition>();
            var models = new List<RedisToolAlertConditionModel>();
            req.data.ForEach(x =>
            {
                data.Add(new SigerProjectToolAlertCondition()
                {
                    cutterlocationid=x.cutterlocationid,
                    condition_param=x.condition_param,
                    condition_type=x.condition_type,
                    is_open=x.is_open,
                    k=x.k,
                    m=x.m,
                    status=x.status,
                    createtime=UnixTimeHelper.GetNow()
                });
            });
            data.ForEach(x =>
            {
                sigerProjectToolAlertConditionRepository.Insert(x);
                models.Add(Mapper<SigerProjectToolAlertCondition, RedisToolAlertConditionModel>.Map(x));
            });
            if(unitOfWork.Commit()>0)
            {
                try
                {
                    AlarmConditionRepository alarmConditionRepository = new AlarmConditionRepository(CompanyId, ProjectId);
                    alarmConditionRepository.Add(req.cutterlocationid, models);
                }
                catch (System.Exception)
                {
                    
                }
                
                return Ok();
            }
                

            throw new BadRequestException(CommonEnum.Fail);
        }
        [HttpPost]
        public IActionResult DeleteAlertSetting([FromBody]RequestToolConfigAlertSetting req)
        {
            //清空原来的配置
            var oldData = sigerProjectToolAlertConditionRepository.GetList(f => f.cutterlocationid == req.cutterlocationid).Select(f => f.id).ToList();
            oldData.ForEach(x =>
            {
                sigerProjectToolAlertConditionRepository.Delete(x);
            });
            if (unitOfWork.Commit() > 0)
            {
                try
                {
                    AlarmConditionRepository alarmConditionRepository = new AlarmConditionRepository(CompanyId,ProjectId);
                    alarmConditionRepository.DeleteChangeToolsRecord(req.cutterlocationid);
                }
                catch (System.Exception)
                {
                    
                }
                return Ok();
            }
                

            throw new BadRequestException(CommonEnum.Fail);
        }

        [HttpGet]
        public IActionResult GetCutterLocationList([FromBody]RequestGetCutterLocationAlarmSetting req)
        {
            var data = _sigerProjectToolCutterLocationTrueRepository.GetCutterLocationList(req.sectionid, CompanyId, ProjectId, req.page, req.pagesize,out int totalCount);
            return new PagedObjectResult(data, totalCount, req.page,req.pagesize);
        }

        [HttpGet]
        public IActionResult GetAlertSettingList(int id)
        {
            return new ObjectResult(sigerProjectToolAlertConditionRepository.GetAlertSettingInfo(id));
        }
    }
}