﻿using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository.Request;

namespace Siger.ApiWMS.Controllers
{
    /// <summary>
    /// APP端接口
    /// </summary>
    public class AppController : BaseController
    {
        private readonly Isiger_wms_stocktake_orderRepository stocktack;
        private readonly Isiger_wms_stocktake_order_detailRepository detail;
        private readonly IUnitOfWork _unitOfWork;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="stocktack"></param>
        /// <param name="detail"></param>
        /// <param name="unitOfWork"></param>
        public AppController(Isiger_wms_stocktake_orderRepository stocktack, Isiger_wms_stocktake_order_detailRepository detail, IUnitOfWork unitOfWork)
        {
            this.stocktack = stocktack;
            this.detail = detail;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取汇总数据
        /// </summary>
        /// <returns></returns>
        public IActionResult GetTotalInfo()
        {
            //盘点完成只显示最近完成的10条
            var result = stocktack.GetTotalInfo(ProjectId);

            return new ObjectResult(result);
        }

        /// <summary>
        /// 获取盘点详情
        /// </summary>
        /// <returns></returns>
        public IActionResult GetDetail(int id)
        {
            var result = stocktack.GetDetail(id, ProjectId);

            return new ObjectResult(result);
        }

        /// <summary>
        /// 提交盘点记录
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public IActionResult UpdateCheck([FromBody]RequestUpdateCheck req)
        {
            detail.UpdateCheck(req.id, req.nodes, ProjectId, UserId);
            
            return Ok();
        }
    }
}