﻿using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.ApiWMS.Controllers
{
    /// <summary>
    /// 供应商
    /// </summary>
    public class BusinessController : BaseController
    {
        private readonly Isiger_wms_bussinese_contactsRepository business;
        private readonly Isiger_wms_areaRepository area;
        private readonly IUnitOfWork _unitOfWork;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="business"></param>
        /// <param name="area"></param>
        /// <param name="unitOfWork"></param>
        public BusinessController(Isiger_wms_bussinese_contactsRepository business, Isiger_wms_areaRepository area, IUnitOfWork unitOfWork)
        {
            this.business = business;
            this.area = area;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取供应商列表、获取客户列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetBusinessList(int materialID, string name, WMSEnum type, int typenameid, int page = 1, int pageSize = 10)
        {
            Utility.CheckPage(page, pageSize);
            var data = business.GetBusinessList(materialID, ProjectId, name, type, typenameid, out int count, page, pageSize);
            return new PagedObjectResult(data, count, page, pageSize);
        }
        /// <summary>
        /// 供应商名称列表
        /// </summary>
        /// <returns></returns>
        public IActionResult GetSupplierNameList(WMSEnum type)
        {
            switch (type)
            {
                case WMSEnum.Business:
                    break;
                case WMSEnum.Customer:
                    break;
                default:
                    throw new BadRequestException(RequestEnum.BusinessTypeError);
            }
            var result = business.GetList(f => f.supply_type == (int)type && f.status == (int)RowState.Valid && f.projectid == ProjectId).Select(f => new
            {
                f.id,
                f.name,
            }).ToList();
            return new ObjectResult(result);
        }
        /// <summary>
        /// 获取所有客户类型列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetAreaType(WMSEnum type)
        {
            var list = area.GetAreaType(type);
            var response = new ResponseLevelSectionChildren(Utility.ConvertToTree(list));

            return new ObjectResult(response);
        }
        /// <summary>
        /// 获取最后一级客户类型列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetLastAreaType()
        {
            var list = area.GetLastArea().Select(f => new
            {
                f.id,
                f.name
            });

            return new ObjectResult(list);
        }
    }
}