﻿using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;

namespace Siger.ApiWMS.Controllers
{
    public class InventoryController : BaseController
    {
        private readonly Isiger_wms_stockRepository stock;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="stock"></param>
        public InventoryController(Isiger_wms_stockRepository stock)
        {
            this.stock = stock;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public IActionResult GetInventoryList(int businessID)
        {
            var list = stock.GetInventoryList(businessID, ProjectId).Select(f => new ResponseIdName { id = f.id, name = f.pn }); ;
            return new ObjectResult(list);
        }
        /// <summary>
        /// 供应商列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetBusinessList(int materialID)
        {
            var list = stock.GetBusinessList(materialID, ProjectId);
            return new ObjectResult(list);
        }
        /// <summary>
        /// 查询物料信息
        /// </summary>
        /// <param name="pn"></param>
        /// <param name="businessId"></param>
        /// <param name="count">取多少条记录</param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetInventoryListByName(string pn, int businessId, int count)
        {
            var inventoryList = stock.GetInventoryList(businessId, ProjectId).ToList();
            if (!string.IsNullOrWhiteSpace(pn))
            {
                var resp = inventoryList.Where(f => f.pn.Contains(pn)).OrderByDescending(g => g.transdatetime)
                    .Select(s => new ResponseIdName { id = s.id, name = s.pn });
                return new ObjectResult(resp);
            }
            var response = inventoryList.OrderByDescending(g => g.transdatetime).Select(s => new ResponseIdName { id = s.id, name = s.pn });
            if (count != 0)
            {
                response = response.Take(count);
            }
            return new ObjectResult(response);
        }
    }
}