﻿using Siger.ApiCommon.Utilities;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Data;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace Siger.ApiWMS
{
    public class Utility
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="page"></param>
        /// <param name="pageSize"></param>
        public static void CheckPage(int page, int pageSize)
        {
            if (page <= 0)
                throw new BadRequestException(RequestEnum.PageError);
            if (pageSize <= 0)
                throw new BadRequestException(RequestEnum.PageSizeError);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="models"></param>
        /// <returns></returns>
        public static IList<LevelSectionTree> ConvertToTree(IEnumerable<LevelSectionTree> models)
        {
            var section = new Dictionary<int, LevelSectionTree>();
            foreach (var item in models)
            {
                section.Add(item.id, item);
            }
            var result = new List<LevelSectionTree>();
            foreach (var item in section.Values)
            {
                if (item.pid == 0)
                {
                    result.Add(item);
                }
                else
                {
                    if (section.ContainsKey(item.pid))
                    {
                        section[item.pid].AddChilrden(item);
                    }
                }
            }
            return result;
        }
       
        public static string GenSerialNumber()
        {
            return $"{GenKey()}{UnixTimeHelper.GetNow()}";
        }
        private static string GenKey()
        {
            char value1 = (char)((new Random().Next() % 26) + 'A');
            char value2 = (char)((new Random().Next() % 26) + 'A');
            return $"{value1}{value2}";
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="temporaryFileName"></param>
        public static string GetPath(string temporaryFileName)
        {

            var fileSetting = Config<FileSettings>.Get();
            if (fileSetting == null)
            {
                throw new BadRequestException(CommonEnum.GetCommCfgFailed);
            }

            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            return Path.Combine(rootDir, temporaryFileName);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetExcelFileName(string fileType)
        {
            //获取配置信息
            var fileSetting = Config<FileSettings>.Get();
            if (fileSetting == null)
            {
                throw new BadRequestException(CommonEnum.GetCommCfgFailed);
            }
            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            string fileName = $"{fileType}{DateTime.Now:yyyyMMddHHmmss}.xlsx";

            return Path.Combine(rootDir, fileName);
        }
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetExcelFileDisplayName(string fileName)
        {
            //获取配置信息            
            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            
            return $"{FileSystemHelper.CommonFileSetting.RequestPath}/{FileSystemHelper.ExportFileName}/{fileName}";
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public static string GetExcelTmpFileName(string fileType, string filename)
        {
            //获取配置信息
            var fileSetting = Config<FileSettings>.Get();
            if (fileSetting == null)
            {
                throw new BadRequestException(CommonEnum.GetCommCfgFailed);
            }
            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            string fileName = $"{DateTime.Now:yyyyMMddHHmmss}tmp{fileType}Import.{Path.GetExtension(filename)}";

            return Path.Combine(rootDir, fileName);
        }
        /// <summary>
        /// 生成储位编号
        /// </summary>
        /// <param name="wavehouse"></param>
        /// <param name="area"></param>
        /// <param name="shelves"></param>
        /// <param name="layer"></param>
        /// <param name="location"></param>
        /// <returns></returns>
        public static string GenLocationSerialNumber(int wavehouse, int area, int shelves, int layer, int location)
        {
            return $"C{wavehouse}_H{area}_Z{shelves}_C{layer}_{location}";
        }

        public static IQueryable<t> Paging<t>(IQueryable<t> list, int page, int pageSize)
        {
            list = list.Skip((page - 1) * pageSize).Take(pageSize);
            return list;
        }
        public static string GetTime(DateTime t)
        {
            return (t == DateTime.MinValue || t == null) ? "" : t.ToString(UnixTimeHelper.DateTimeFormat);
        }

        /// <summary>
        /// 获取导出文件名称
        /// </summary>
        /// <param name="baseName"></param>
        /// <returns></returns>
        public static string GetExportFileName(string baseName)
        {
            //获取配置信息
            var fileSetting = Config<FileSettings>.Get();
            if (fileSetting == null)
            {
                throw new BadRequestException(CommonEnum.GetCommCfgFailed);
            }
            var rootDir = FileSystemHelper.GetPhysicalFolders(FileSystemHelper.CommonFileSetting.PhysicalFolder, FileSystemHelper.ExportFileName);
            string temporaryFileName = $"{baseName}_{DateTime.Now:yyyyMMddHHmmss}.xlsx";
            return Path.Combine(rootDir, temporaryFileName);
        }       
    }
    public class kv
    {
        public int k;
        public string v;
    }
}
