﻿using System;

namespace Siger.Middlelayer.Common.Extensions
{
    public static class StringExtensions
    {
        public static T ToJson<T>(this object value)
        {
            object result;
            Type type = typeof(T);
            try
            {
                if (type == typeof(string))
                {
                    result = value;
                }
                else
                {
                    result = Convert.ChangeType(value, type);
                }
            }
            catch (Exception)
            {
                result = default(T);
            }
            return (T)result;
        }

        public static T ToObject<T>(this object value)
        {
            object result;
            Type type = typeof(T);
            try
            {
                if (type == typeof(string))
                {
                    result = value;
                }
                else
                {
                    result = Convert.ChangeType(value, type);
                }
            }
            catch (Exception)
            {
                result = default(T);
            }
            return (T)result;
        }
    }
}
