﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Siger.Middlelayer.Common.Helpers
{
    public class ColorHelper
    {
        public static List<string> Colors = new List<string>();

        static ColorHelper()
        {
            var colors = new[]{"#3A5FCD", "#FF7F50", "#FFD700", "#FF8C69", "#FF4500", "#F08080", "#FF34B3", "#BF3EFF", "#000080", "#CD3700"
                ,"#AEEEEE","#B4EEB4","#B8B8B8","#B8860B","#7FFF00","#00CD00","#FF0000","#FF6600","#FF6600","#FFFF00","#55AA55","#6F2BD5",
                "#887782","#AE33CC","#7B7788","#3C57C4","#33CC52","#33CC52","#CC3352","#CC3352","#44BB44","#8FCC33" };
            foreach (var color in colors.Distinct())
            {
                Colors.Add(color);
            }
        }

        public static List<string> GetColors(int num)
        {
            if (num == 1)
            {
                return new List<string> { Colors.First() };
            }

            if (num > Colors.Count)
            {
                return Colors;
            }

            return Colors.Take(num).ToList();
        }

        public static string RandomColor()
        {
            var str = "#";
            var aryNum = new[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
            for (var i = 0; i < 6; i++)
            {
                var random = new Random().Next(aryNum.Length);
                str += aryNum[random];
            }
            return str;
        }
        
    }
}
