﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.IO;
using Siger.Middlelayer.Common.AppSettings;
using Siger.Middlelayer.Common.Configuration;

namespace Siger.Middlelayer.Common.Helpers
{
    public class FileSystemHelper
    {
        private static string fileSettingSectionName = "FileSetting";
        private static FileSetting fileSetting =null;

        private static string fileSysDirName = "SigerFileMangerSys";

        private static string linuxRoot = "/opt";

        private static string exportFileName = "ExportFiles";

        private static string templateFileName = "Templates";

        private static string importFileName = "import";

        private static string markTempFileName = "MarkTemplate";

        public static FileSetting CommonFileSetting
        {
            get
            {
                if (fileSetting == null)
                {
                    fileSetting = ConfigManager.GetSection<FileSetting>(fileSettingSectionName);
                }
                return fileSetting;
            }
        }

        public static string MarkTempFileName
        {
            get
            {
                
                return markTempFileName;
            }
        }

        public static string TemplateFileName
        {
            get
            {
                return templateFileName;
            }
        }


        public static string ExportFileName
        {
            get
            {
                return exportFileName;
            }
        }

        public static string ImportFileName
        {
            get
            {
                return importFileName;
            }
        }

        private static bool? _isLinux = null;
        public static bool IsLinux
        {
            get
            {
                if (_isLinux == null)
                {
                    _isLinux = RuntimeInformation.IsOSPlatform(OSPlatform.Linux);
                }
                return (bool)_isLinux;
            }
        }

        private static string _rootPath = "";
        public static string RootPath
        {
            get
            {
                if (string.IsNullOrEmpty(_rootPath))
                {
                    if (CommonFileSetting.IsFileSeparation)
                    {
                        if (IsLinux)
                        {
                            _rootPath = Path.Combine(linuxRoot, fileSysDirName);
                        }
                        else
                        {
                            var currentProgramePath = AppDomain.CurrentDomain.BaseDirectory;
                            var fileRoot = currentProgramePath.Substring(0, currentProgramePath.IndexOf(":") + 1);
                            _rootPath = Path.Combine(fileRoot, fileSysDirName);
                        }
                    }
                    else
                    {
                        _rootPath = AppDomain.CurrentDomain.BaseDirectory;
                    }
                    if (!Directory.Exists(_rootPath))
                    {
                        Directory.CreateDirectory(_rootPath);
                    }
                }
                return _rootPath;
            }
        }
      

        public static string GetPhysicalFolders(params string[] actFolderNames)
        {
            if (actFolderNames != null)
            {
                var physicalActDir = RootPath;
                foreach (var item in actFolderNames)
                {
                    physicalActDir = Path.Combine(physicalActDir, item);
                }
                if (!Directory.Exists(physicalActDir))
                {
                    Directory.CreateDirectory(physicalActDir);
                }
                return physicalActDir;
            }

            return "";
        }
    }
}
