﻿using System.Collections.Generic;
using System.Net;
using System.Net.Mail;
using System.Text;
using System.Threading.Tasks;

namespace Siger.Middlelayer.Common.Helpers
{
    public class MailHelper
    {
        /// <summary>
        /// 发送电子邮件
        /// </summary>
        /// <param name="smtpserver">SMTP服务器</param>
        /// <param name="enableSsl">是否启用SSL加密</param>
        /// <param name="userName">登录帐号</param>
        /// <param name="pwd">登录密码</param>
        /// <param name="nickName">发件人昵称</param>
        /// <param name="fromMail">发件人</param>
        /// <param name="toMail">收件人</param>
        /// <param name="subj">主题</param>
        /// <param name="bodys">内容</param>
        /// <returns></returns>

        public static async Task SendMailAsync(string smtpserver, bool enableSsl, string userName, string pwd, string nickName, string fromMail, List<string> toMail, string subj, string bodys)

        {

            SmtpClient smtpClient = new SmtpClient();

            smtpClient.DeliveryMethod = SmtpDeliveryMethod.Network;//指定电子邮件发送方式

            smtpClient.Host = smtpserver;//指定SMTP服务器

            smtpClient.Credentials = new NetworkCredential(userName, pwd);//用户名和密码

            smtpClient.EnableSsl = enableSsl;

            MailAddress fromAddress = new MailAddress(fromMail, nickName);

            MailMessage mailMessage = new MailMessage();

            mailMessage.From = fromAddress;
            //向收件人地址集合添加邮件地址
            if (toMail != null)
            {
                for (int i = 0; i < toMail.Count; i++)
                {
                    mailMessage.To.Add(toMail[i].ToString());
                }
            }

            mailMessage.Subject = subj;//主题

            mailMessage.Body = bodys;//内容

            mailMessage.BodyEncoding = Encoding.Default;//正文编码

            mailMessage.IsBodyHtml = true;//设置为HTML格式

            mailMessage.Priority = MailPriority.Normal;//优先级

            await smtpClient.SendMailAsync(mailMessage);

        }

        public static void SendMail(string smtpserver, bool enableSsl, string userName, string pwd, string nickName, string fromMail, string toMail, string subj, string bodys, List<string> filesList)
        {
            SmtpClient smtpClient = new SmtpClient
            {
                DeliveryMethod = SmtpDeliveryMethod.Network,
                Host = smtpserver,
                Port = 25,
                Credentials = new NetworkCredential(userName, pwd),
                EnableSsl = enableSsl
            };

            MailAddress fromAddress = new MailAddress(fromMail, nickName);
            MailAddress toAddress = new MailAddress(toMail);
            MailMessage mailMessage = new MailMessage(fromAddress, toAddress)
            {
                Subject = subj,
                Body = bodys,
                BodyEncoding = Encoding.Default,
                IsBodyHtml = true,
                Priority = MailPriority.Normal
            };

            foreach (var file in filesList)
            {
                var amAnnex = new Attachment(file);
                mailMessage.Attachments.Add(amAnnex);
            }

            smtpClient.Send(mailMessage);

        }

        public static void SendMailForUsers(string smtpserver, bool enableSsl, string userName, string pwd, string nickName, string fromMail, IList<string> toMails, string subj, string bodys, List<string> filesList)
        {
            SmtpClient smtpClient = new SmtpClient
            {
                DeliveryMethod = SmtpDeliveryMethod.Network,
                Host = smtpserver,
                Port = 25,
                Credentials = new NetworkCredential(userName, pwd),
                EnableSsl = enableSsl
            };

            MailAddress fromAddress = new MailAddress(fromMail, nickName);
            //MailAddress toAddress = new MailAddress(toMail);
            MailMessage mailMessage = new MailMessage
            {
                Subject = subj,
                Body = bodys,
                BodyEncoding = Encoding.Default,
                IsBodyHtml = true,
                Priority = MailPriority.Normal,
                From = fromAddress
            };
            foreach (var toMail in toMails)
            {
                mailMessage.To.Add(toMail);
            }

            foreach (var file in filesList)
            {
                var amAnnex = new Attachment(file);
                mailMessage.Attachments.Add(amAnnex);
            }

            smtpClient.Send(mailMessage);

        }
    }
}
