﻿using Siger.Middlelayer.Common;
using System;
using System.Threading.Tasks;

namespace Siger.Middlelayer.Log
{
    public abstract class LogEngine : IDisposable
    {
        protected Module Module { get; set; }

        protected LogEngine(Module module)
        {
            Module = module;
        }

        /// <summary>
        /// Write the log async
        /// </summary>
        /// <param name="level">Log's level see <see cref="LogLevel"/></param>
        /// <param name="msg">The message to write</param>
        public abstract Task WriteAsync(LogLevel level, string msg);

        /// <summary>
        /// Write the log
        /// </summary>
        /// <param name="level">Log's level see <see cref="LogLevel"/></param>
        /// <param name="msg">The message to write</param>
        public abstract void Write(LogLevel level, string msg);

        public virtual void Dispose()
        {
            //Nothing.
        }
    }
}
