﻿using System;

namespace Siger.Middlelayer.Log
{
    public class Performance : IDisposable
    {
#if DEBUG
        private readonly int _performanceThreshold;
        private readonly string _message;
        private readonly int _startTime;
#endif

        public Performance(string message)
        {
#if DEBUG
            _performanceThreshold = 100;
            _startTime = Environment.TickCount;
            _message = message;
            Logger.WriteLineInfo($"Perf: {_message} starting");
#endif
        }

        public Performance(string format, params object[] args)
        {
#if DEBUG
            _performanceThreshold = 100;
            _startTime = Environment.TickCount;
            _message = string.Format(format, args);
            Logger.WriteLineInfo($"Perf: {_message} starting");
#endif
        }

        public Performance(int performanceThreshold, string format, params object[] args)
        {
#if DEBUG
            _performanceThreshold = performanceThreshold;
            _startTime = Environment.TickCount;
            _message = string.Format(format, args);
            Logger.WriteLineInfo($"Perf: {_message} starting");
#endif
        }

        public void Dispose()
        {
#if DEBUG
            var endTime = Environment.TickCount;
            var intervals = endTime - _startTime;
            if (intervals > _performanceThreshold)
            {
                Logger.WriteLineWarn($"Perf: {_message} end. {intervals} ms");
            }
            else
            {
                Logger.WriteLineInfo($"Perf: {_message} end. {intervals} ms");
            }

#endif
        }
    }
}
