﻿using System.ComponentModel;

namespace Siger.Middlelayer.Common.FieldEnum
{
    public enum TlmSettingCategory
    {
        /// <summary>
        /// 刀具
        /// </summary>
        [Description("刀具")]
        Cutter = 1,

        /// <summary>
        /// 刀柄
        /// </summary>
        [Description("刀柄")]
        Handler,

        /// <summary>
        /// 附件
        /// </summary>
        [Description("附件")]
        Attachment,
        /// <summary>
        /// 刀头
        /// </summary>
        [Description("刀头")]
        Cut
    }
    public enum ImsSettingCategory
    {
        /// <summary>
        /// 模具
        /// </summary>
        [Description("模具")]
        Mould = 1,

        /// <summary>
        /// 模芯
        /// </summary>
        [Description("模芯")]
        Core,
    }

    public enum YesNoCategory
    {
        [Description("否")]
        No,

        [Description("是")]
        Yes
    }

    public enum ToolStatus
    {
        [Description("未确认")]
        UnConfirmed,
    }

    public enum MeasureResult
    {
        [Description("未测量")]
        Unmeasured,

        [Description("合格")]
        Qualified,

        [Description("不合格")]
        UnQualified,
    }

    public enum OrderStatus
    {
        [Description("未处理")]
        Untreated,

        [Description("备刀中")]
        Preparing,

        [Description("备刀完成")]
        Completed,
    }

    public enum ChoiceStatus
    {
        [Description("未申请")]
        UnApply = 1,

        [Description("已申请")]
        HasApply

    }

    public enum ToolChoiceStatus
    {
        [Description("未选择")]
        UnChoice,

        [Description("已选择")]
        HasChoice,

        [Description("已出库")]
        HasOutStock

    }

    public enum InstallCategory
    {
        [Description("安装")]
        Install = 1,

        [Description("卸载")]
        UnInstall,
    }

    public enum StorageCategory
    {
        [Description("领用")]
        Use = 1,

        [Description("回收")]
        Recovery,

        [Description("修磨")]
        Grinding,

        [Description("报废")]
        Abandonment
    }

    public enum GrindTypeStatus
    {
        [Description("自主修磨")]
        Autonomy = 1,

        [Description("外协修磨")]
        Assist
    }

    /// <summary>
    /// 是否修磨
    /// </summary>
    public enum NeedGrindStatus
    {
        [Description("可修磨")]
        Yes = 1,

        [Description("不可修磨")]
        No
    }

    public enum ToolGrindStatus
    {
        [Description("待修磨")]
        UnGrind = 1,

        [Description("修磨已申请")]
        Apply,

        [Description("修磨完成")]
        Completed,
    }

    public enum ToolScrapStatus
    {
        [Description("未审核")]
        Aduiting = 1,

        [Description("审核通过")]
        Aduited,

        [Description("审核未通过")]
        Reject,
    }

    public enum ReplaceReturnTypeStatus
    {
        [Description("更换")]
        Replace = 1,

        [Description("归还")]
        SendBack,

        [Description("领用")]
        Recieve
    }

    public enum ScrapGrindSourceStatus
    {
        [Description("其他")]
        Other,

        [Description("本表")]
        Self,

        [Description("更换归还")]
        ReplaceReturn
    }

    public enum ToolAmountStatus
    {
        [Description("报废量")]
        AbandonmentAmount = 1,

        [Description("修磨量")]
        GrindingAmount,

        [Description("使用量")]
        UseAmount
    }

    public enum TlmDetectionState
    {
        [Description("退货")]
        Return = 0,
        /// <summary>
        /// 待检测
        /// </summary>
        [Description("待检测")]
        WaitInspect = 1,
        /// <summary>
        /// 检测完成
        /// </summary>
        [Description("检测完成")]
        Inspected,
        /// <summary>
        /// 待测试
        /// </summary>
        [Description("待测试")]
        WaitTest,
        /// <summary>
        /// 测试完成
        /// </summary>
        [Description("测试完成")]
        Tested,
        [Description("入库")]
        InStock = 997,
        [Description("检测退货")]
        InspectReturn = 998,
        [Description("测试退货")]
        TestReturn
    }
}
