﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Siger.Middlelayer.Common.ModuleEnum
{
    /// <summary>
    /// tpm module, start from 7000000
    /// </summary>
    public enum TpmEnum
    {
        [Description("各节点上报时间不能为空")]
        ProcessTimeNull = 7000001,
        [Description("各节点上报岗位不能为空")]
        ProcessLevelNull,
        [Description("当前设备没有绑定产线")]
        MachineNotFind,
        [Description("没有找到当前安灯类型")]
        ExpectionNotFound,
        [Description("已有安灯触发")]
        AndonTriggered,
        [Description("安灯信息未找到")]
        AndonNotFound,
        [Description("当前状态无法确认到货")]
        OrderCanNotConfirm,
        [Description("当前状态已经确认到货")]
        OrderConfirmed,
        [Description("所选时间转化失败")]
        TimeError,
        [Description("无法使用当前时间")]
        CanNotUseThisTime,
        [Description("当前地址无效或已经过期")]
        TokenVaild,
        [Description("您不属于该异常的负责岗位，没有解除权限")]
        UsergroupNotInCompleteExpection,
        [Description("您不属于该异常的负责岗位，没有签到权限")]
        UsergroupNotInHandlingExpection,
        [Description("请选择换型产品")]
        ProductCodeInvalid,
        
        [Description("不能调整到下次执行日期之后")]
        CannotChangeToThisTime,
        [Description("同类型的安灯已经触发，无需重复触发！")]
        AndonExist,
        [Description("安灯触发失败！原因是设备维修工单创建失败！")]
        RepairDataCreateFailed,
        [Description("安灯当前状态请前往设备维修管理中处理")]
        AndonStatusCanNotHandle,
        [Description("设备当前状态请前往安灯管理中处理")]
        MachinStatusCanNotHandle,
        [Description("该时间范围内已存在停机记录")]
        StopMachineExist,
        [Description("父级类型与该类型不能一致")]
        ExpectionParentError,
        [Description("请确认计划安排时间是否冲突")]
        PlanTimeError= 7000049,
        [Description("本条安灯已经生效，此状态下不支持删除")]
        CancleAndonFailed,
        [Description("未找到审核流程信息！")]
        EsopProcessDataNotFound,
    }

    public enum MachineRepairStatus
    {
        [Description("待接单")]
        WaitingForOrders = 1,

        [Description("待签到")]
        WaitingForCheckIn = 2,

        [Description("待维修")]
        WaitingForRepair = 3,

        [Description("待复线")]
        WaitingForRenew = 4,

        [Description("待反馈")]
        WaitingForFeedback = 5,

        [Description("已完成")]
        Completed = 6,

        [Description("删除")]
        Deleted,
    }

    public enum WorkCode_Type
    {
        [Description("应急维修")]
        Repair = 1,
        [Description("事后维修")]
        afterRepair,
        [Description("计划维修")]
        PlanRepair,
        [Description("计划维护")]
        PlanMaintain
    }

    public enum StockCategory
    {
        [Description("出库")]
        OutStock = 1,

        [Description("入库")]
        InStock,
    }

    /// <summary>
    /// 入库
    /// </summary>
    public enum InStockCategory
    {
        [Description("采购入库")]
        Procurement = 1,

        [Description("生产入库")]
        Sales,

        [Description("领用退回入库")]
        Emergency,

        [Description("借贷入库")]
        Loan,

        [Description("借出还入")]
        Borrow,

        [Description("对账入库")]
        Reconciliation,

        [Description("返修入库")]
        PlanRepair,
    }

    /// <summary>
    /// 出库
    /// </summary>
    public enum OutStockCategory
    {
        [Description("采购提货出库")]
        Procurement = 1,

        [Description("销售提货出库")]
        Sales,

        [Description("应急维修领用出库")]
        Emergency,

        [Description("借贷出库")]
        Loan,

        [Description("借入还出")]
        Borrow,

        [Description("对账出库")]
        Reconciliation,

        [Description("计划维护领用出库")]
        PlanRepair,
    }

    /// <summary>
    /// 计划维护状态
    /// </summary>
    public enum PlanStatus
    {
        [Description("正常")]
        Normal = 1,

        [Description("未执行")]
        UnExecuted,

        [Description("逾期")]
        Overdue,
    }

    /// <summary>
    /// 是否免打扰状态
    /// </summary>
    public enum MuteStatus
    {
        [Description("免打扰")]
        Open = 0,

        [Description("关闭免打扰")]
        Close,
    }

    /// <summary>
    /// 执行日期范围
    /// </summary>
    public enum DateRangStatus
    {
        [Description("一直执行(1年)")]
        Always = 1,

        [Description("自定义执行日期范围")]
        Custom,

        [Description("按次数执行")]
        Number,
    }

    public enum RepairOrPlanStatus
    {
        [Description("应急维修")]
        Repair = 1,

        [Description("计划维护")]
        Plan,

        [Description("安灯")]
        Andon,
    }

    public enum AppPushType
    {
        [Description("推送并保存消息")]
        PushAndSave = 1,

        [Description("只保存消息不推送")]
        SaveNotPush
    }

    public enum PlanModeType
    {
        [Description("自主执行")]
        AM = 1,

        [Description("手动执行")]
        PM
    }
    public enum AndonState
    {
        [Description("正常")]
        Normal,
        [Description("异常")]
        Abnormal,
        [Description("未处理")]//此状态触发推送
        WaitHandle,
        [Description("已签到")]//此状态处理推送
        Handling,
        [Description("未确认")]//此状态解除推送
        Complete,
        [Description("已确认")]
        Approve,
        [Description("复线")]
        Recovery,
        [Description("让步复线")]
        Com_Approve,
        [Description("拒绝复线")]
        CanNotRecovery,
        [Description("异常关闭")]
        CancleAbnormal = 9997,
        [Description("安灯关闭")]
        CancleAndon= 9998,
        [Description("推送状态")]
        MessagePush = 9999,
    }
    public enum FaultType
    {
        [Description("失效模式")]
        FailureMode = 1,
        [Description("失效原因")]
        FailureReason,
        [Description("修复措施")]
        RepairMeasures,
    }
    public enum OrderStatus
    {
        [Description("未提交")]

        NotSubmitted = 1,
        [Description("采购中")]

        Purchasing,
        [Description("已完成")]

        Completed
    }
    public enum OrderType
    {
        [Description("普通采购")]

        Normal = 1,
        [Description("紧急采购")]

        Urgent,

    }
    public enum ApproveStatus
    {
        [Description("未审核")]

        WaitAudit = 1,
        [Description("审核中")]

        Audit,
        [Description("已通过")]

        Pass,
        [Description("未通过")]

        NotPass,
    }

    public enum SparepartAuditCategory
    {

        [Description("审核")]
        Audit = 1,

        [Description("备货")]
        Prepare,

        [Description("替换")]
        Replace,
    }
}
