﻿using System.ComponentModel;

namespace Siger.Middlelayer.Common
{
    /// <summary>
    /// request error code, start from 9000000
    /// </summary>
    public enum RequestEnum
    {
        [Description("邮箱不能为空")]
        EmailIsEmpty = 9000000,

        [Description("Id不能为空")]
        IdIsEmpty,

        [Description("名称不能为空")]
        NameIsEmpty,

        [Description("描述不能为空")]
        DescriptionIsEmpty,

        [Description("标题不能为空")]
        TitleIsEmpty,

        [Description("手机号不能为空")]
        MobileIsEmpty,

        [Description("工号不能为空")]
        WorkCodeIsEmpty,

        [Description("密码不能为空")]
        PasswordIsEmpty,

        [Description("固定资产编号不能为空")]
        CodeIsEmpty,

        [Description("省份代码不能为空")]
        ProvinceCodeIsEmpty,

        [Description("城市代码不能为空")]
        CityCodeIsEmpty,

        [Description("企业未找到")]
        CompanyNotFound,

        [Description("中文名称不能为空")]
        ChinesenameIsEmpty,

        [Description("中文拼音不能为空")]
        ChinesepinyinIsEmpty,

        [Description("省份不能为空")]
        ProvinceIsEmpty,

        [Description("详细地址不能为空")]
        DetailaddressIsEmpty,

        [Description("行业一级不能为空")]
        IndustryFirstIsEmpty,

        [Description("行业二级不能为空")]
        IndustrySecondIsEmpty,

        [Description("手机不能为空")]
        TelephoneIsEmpty,

        [Description("邮箱不能为空")]
        CompanyEmailIsEmpty,

        [Description("联系人不能为空")]
        ContactIsEmpty,

        [Description("项目未找到")]
        ProjectNotFound,

        [Description("层级未找到")]
        LevelNotFound,

        [Description("层级标题不能为空")]
        LevelTitleIsEmpty,

        [Description("产品图纸号不能为空")]
        DrawingcodeIsEmpty,

        [Description("用户已存在")]
        UserIsExist,

        [Description("部门已存在")]
        SectionHasExist,

        [Description("项目名称已存在")]
        ProjectIsExist,

        [Description("项目类型未找到")]
        ProjectTypeNotFound,

        [Description("项目层级未找到")]
        ProjectLevelNotFound,

        [Description("角色未找到")]
        RoleNotFound,

        [Description("权限未找到")]
        UserPowerIsNotFound,

        [Description("权限值为空")]
        UserPowerIsEmpty,

        [Description("父级权限为空")]
        ParnetPowerIsEmpty,

        [Description("岗位未找到")]
        UserGroupNotFound,

        [Description("部门未找到")]
        SectionNotFound,

        [Description("用户未找到")]
        UserNotFound,

        [Description("项目用户未找到")]
        ProjectUserNotFound,

        [Description("部门层级未找到")]
        LevelSectionNotFound,

        [Description("设备未找到")]
        MachineNotFound,

        [Description("设备类型未找到")]
        MachineTypeNotFound,

        [Description("产品未找到")]
        ProductNotFound,

        [Description("备件类型未找到")]
        SparepartTypeNotFound,

        [Description("用户名不能为空")]
        Username_NotNull ,

        [Description("密码不能为空")]
        Password_NotNull,

        [Description("部门Id不能为空")]
        SectionIDNotNull,

        [Description("用户组Id不能为空")]
        UserGroupidIDNull,

        [Description("时间段不能为空")]
        TimeSpanNotNull,

        [Description("设备Id不能为空")]
        MachineIDNotNull,

        [Description("程序号不能为空")]
        ProgramNoNotNull,

        [Description("刀具名称不能为空")]
        SpindleNameNotNull,

        [Description("刀位不能为空")]
        CutterLocationNameNotNull,

        [Description("报警时间不能为空")]
        AlarmTimeNotNull,

        [Description("导入失败")]
        ImportFailed,

        [Description("请选择x,y轴")]
        XORYNotNull,

        [Description("开始时间不能为空")]
        StartTimeNotNull,

        [Description("结束时间不能为空")]
        EndTimeNotNull,

        [Description("开始时间必须小于结束时间")]
        StartTimeGtEndTime,

        [Description("标题已存在")]
        TitleHasExist,

        [Description("名称已存在")]
        NameHasExist,

        [Description("工号已存在")]
        WorkcodeHasExist,

        [Description("手机号已存在")]
        MobileHasExist,

        [Description("所选项目层级已添加对应产线层级，不能清空")]
        ProjectLevelCannotDelete,

        [Description("添加用户字段失败")]
        AddProjectUserKeyValueFailed,

        [Description("层次未找到")]
        LevelIsEmpty,

        [Description("导出失败")]
        ExportFailed,

        [Description("企业不能为空")]
        CompanyIdIsEmpty,

        [Description("销售不能为空")]
        SalesIdIsEmpty,

        [Description("项目为空")]
        ProjectIdIsEmpty,

        [Description("上下班时间不能为空")]
        ShiftIsEmpty,

        [Description("班次未找到")]
        ShiftNotFound,

        [Description("组别未找到")]
        ProjectGroupNotFound,

        [Description("删除用户设置字段失败")]
        DeleteProjectUserKeyValueFailed,

        [Description("用户设置字段不能为空")]
        ProjectUserKeyValueIsEmpty,

        [Description("已存在相同的用户设置字段")]
        ProjectUserKeyValueHasExist,
    
        [Description("岗位设置字段不能为空")]
        UserGroupKeyValueIsEmpty,

        [Description("已存在相同的岗位设置字段")]
        UserGroupKeyValueHasExist,

        [Description("班次时间为空")]
        ShiftTimeEmpty,

        [Description("该用户组尚未绑定用户角色")]
        SectionRoleIdIsEmpty,

        [Description("此工位已绑定设备")]
        SectionMachineHasExist,

        [Description("该工位没有绑定设备")]
        SectionMachineNull,

        [Description("固定资产编号已存在")]
        CodeHasExist,

        [Description("设备类型不能为空")]
        TypeIsEmpty,

        [Description("至少添加一条组别")]
        GroupsNotFound,

        [Description("该层级的班次未查到人员")]
        LevelUsersNotFound,

        [Description("程序号类型不能为空")]
        ProgramTypeNotNull,

        [Description("设备名称不能为空")]
        MachineNameNotNull,

        [Description("设备代码不能为空")]//FM-M4-MA-11-02-0847
        MachineCodeNotNull,

        [Description("刀具名称不能为空")]//FM-M4-MA-11-02-0847
        ToolNameNotNull,

        [Description("刀具图纸号不能为空")]//FM-M4-MA-11-02-0847
        DrawingCodeNotNull,

        [Description("供应商不能为空")]
        SupplierNotNull,

        [Description("额定寿命不能为空")]
        RatedLifeNotNull,

        [Description("新刀已使用寿命不能为空")]
        ResidualLifeNotNull,

        [Description("旧刀剩余寿命不能为空")]
        SurplusLifeNotNull,

        [Description("更换时间不能为空")]
        ChangeTimeNotNull,

        [Description("更换原因不能为空")]
        ChangeReasonNotNull,

        [Description("产品图纸号已存在")]
        DrawingCodeHasExist,

        [Description("提交的时间段有冲突")]
        ShiftTimeRangeError,

        [Description("时间段与数据库数据冲突")]
        ShiftTimeRangeErrorInDb,

        [Description("该层级的班次未查到人员")]
        LevelShiftUserNotFound,

        [Description("负载实时监控报表参数不正确")]
        EchartDataParameterError,

        [Description("设备类型子级未找到")]
        MachineChildTypeNotFound,

        [Description("设备类型名称不能为空")]
        MachineTypeNameIsEmpty,

        [Description("请选择部门")]
        SectionIsEmpty,

        [Description("字段名不能为空")]
        FieleNameIsEmpty,

        [Description("标签字数超过限制")]
        FlagLengthLimited,

        [Description("主轴编号不能为空")]
        SpindleIDNotNull,

        [Description("包络线id不能为空")]
        BLXIDNotNull,

        [Description("刀具类型不能为空")]
        Cutter_typeNotNull,

        [Description("刀位Id不能为空")]
        Cutter_location_idNotNull,

        [Description("主轴号不能为空")]
        SpindleNameIsEmpty,

        [Description("刀具未找到")]
        ToolNotFound,

        [Description("刀具已使用数未找到")]
        ToolUsageNotFound,

        [Description("组合名称不能为空")]
        CombTitleIsEmpty,

        [Description("时长不能为空")]
        CycleIsEmpty,

        [Description("页面未找到")]
        PageNotFound,

        [Description("用户id不能为空")]
        MIDNotFound,

        [Description("请选择权限")]
        SelectNoPower,

        [Description("无权限")]
        NoPermission,

        [Description("数据已存在")]
        DataExist,

        [Description("权限记录ID不能为空")]
        PowerIDNotFound,

        [Description("简码已存在")]
        TcodeHasExist,

        [Description("简码必须是两位的数字或字母")]
        TcodeTypeError,

        [Description("请添加txt,eia,mpf,min,spf,cnc,nc,prg,dwg,zip,jpg,eng类型的文件")]
        ErrorFileType,

        [Description("上传文件数量错误")]
        ErrorFileCount,

        [Description("类型不能为空")]
        TimeTypeIsEmpty,

        [Description("创建人不能为空")]
        FounderIsEmpty,

        [Description("开始时间不能为空")]
        StartTimeIsEmpty,

        [Description("结束时间不能为空")]
        EndTimeIsEmpty,

        [Description("产品名称不能为空")]
        ProductNameIsEmpty,

        [Description("请填写故障编码")]
        FaultCodeIsEmpty,

        [Description("请填写故障内容")]
        FaultContentIsEmpty,

        [Description("请填写故障原因")]
        FaultReasonIsEmpty,

        [Description("请填写解决方法")]
        FaultSolutionIsEmpty,

        [Description("工作模式不能为空")]
        WorkingModeIsEmpty,

        [Description("未设置报警邮箱")]
        EmailNotFound,

        [Description("请输入必填选项")]
        ParameterMiss,

        [Description("程序编号不能为空")]
        ProgramidNotNull,

        [Description("文件路径不能为空")]
        File_urlNotNull,

        [Description("文件大小不能为空")]
        File_sizeNotNull,

        [Description("产品编号不能为空")]
        ProductidNotNull,

        [Description("审核人员编号不能为空")]
        CheckmidNotNull,

        [Description("审核备注不能为空")]
        CreateremarkNotNull,

        [Description("发件邮箱不能为空")]
        FirstEmailIsEmpty,

        [Description("服务器地址不能为空")]
        FirstHostIsEmpty,

        [Description("发件授权码不能为空")]
        FirstPasswordIsEmpty,

        [Description("收件邮箱不能为空")]
        SecondEmailIsEmpty,

        [Description("文件路径错误")]
        ErrorFilePath,

        [Description("产品图纸号不存在")]
        ProductDrawingCodeNotFound,

        [Description("设备程序上传失败")]
        UploadError,

        [Description("获取设备程序失败")]
        GetProgramListFailed,

        [Description("获取设备程序信息失败")]
        GetProgramFailed,

        [Description("设备程序下载失败")]
        DownloadError,

        [Description("设备程序删除失败")]
        DeleteError,

        [Description("只能添加最底层类别")]
        AddMaterialsTypeIdError,

        [Description("参数错误")]
        ParameterError,

        [Description("请先选择组合")]
        CobboxIdIsEmpty,

        [Description("RService配置错误")]
        RServiceConfigError,

        [Description("获取负载历史记录失败")]
        RServicePlotHuandaoFailed,

        [Description("负载历史记录异常")]
        RServicePlotHuandaoError,

        [Description("设备类型不能为空")]
        MachineTypeNull,

        [Description("该设备不支持此功能")]
        DeviceNotSupport,

        [Description("该设备不存在")]
        MachineNotExist,

        [Description("设备类型错误")]
        AttributeError,

        [Description("物料类别最多五层")]
        MaterialTypeLevelError,

        [Description("品名已存在")]
        MaterialNameExist,

        [Description("料号已存在")]
        MaterialPnExist,

        [Description("产品编号已存在")]
        ProductidExist,

        [Description("产品编号-产线-工站-结果已存在")]
        RoutingInExist,

        [Description("产线-工站-结果已存在")]
        RoutingOutExist,

        [Description("状态已存在")]
        RoutingOutStatusExist,

        [Description("产品结构清单不存在此物料")]
        ProductStructurePnNotExist,

        [Description("类别名称不能为空")]
        MaterislTypeIsEmpty,

        [Description("简码不能为空")]
        TcodeIsEmpty,

        [Description("先进先出级别不能为空")]
        PriorityIsEmpty,

        [Description("该设备和产品标准节拍尚未配置")]
        CycleTimeNotFound,

        [Description("页码错误")]
        PageError,

        [Description("页记录大小错误")]
        PageSizeError,

        [Description("供应商类别不能为空")]
        TypeIDNotNull,

        [Description("供应商不能为空")]
        BusinessNameNotNull,

        [Description("公司名称不能为空")]
        CompanyNameNotNull,

        [Description("公司地址不能为空")]
        AddressNotNull,

        [Description("联系人不能为空")]
        ContractNotNull,

        [Description("电话不能为空")]
        PhoneNotNull,

        [Description("手机不能为空")]
        MobileNotNull,

        [Description("客户类型不能为空")]
        BusinessTypeNotNull,

        [Description("客户类型错误")]
        BusinessTypeError,

        [Description("类别名称选择错误")]
        CityError,

        [Description("记录id不能为空")]
        IDNotNull,

        [Description("备件编号不能为空")]
        SparepartCodeIsEmpty,

        [Description("最高库存不能为空")]
        MaxStockIsEmpty,

        [Description("最低库存不能为空")]
        MinStockIsEmpty,

        [Description("库存位置不能为空")]
        StockLocationIsEmpty,

        [Description("备件负责人不能为空")]
        StockReportUserIsEmpty,
        
        [Description("报修时间不能大于现在时间")]
        RepairTimeError,

        [Description("仓库类别不能为空")]
        StorageIDNotNull,
        [Description("仓库名称不能为空")]
        StorageNameNotNull,
        [Description("仓库地址不能为空")]
        StorageAddressNotNull,

        [Description("上级储位类别id不能为空")]
        ParentTypeIDNotNull,
        [Description("储位类别名称不能为空")]
        LocationTypeNameNotNull,
        [Description("上级储位类别不存在")]
        LocationPidNotExist,
        [Description("上级储位类别无法为自身")]
        LocationPidCanNotBySelf,

        [Description("上级储位类别不存在")]
        LocationTypeNotExist,

        [Description("储位类别层次数量错误")]
        LocationCountError,

        [Description("储位导入格式错误")]
        LocationImportFormatError,

        [Description("结果字典值未配置")]
        ResultDictNotSet,

        [Description("工站重复")]
        StationRepeat,

        [Description("节点没有出入站")]
        NodeNoLink,

        [Description("节点类型值错误")]
        NodeTypeError,

        [Description("方形节点只能设置成功的出站结果")]
        RectangleNodeOnlySuccess,

        [Description("每条线必须设置一个结果值")]
        LinkNoResult,

        [Description("线必须连接节点")]
        LinkNoBindNode,

        [Description("状态值用完了,请去字典里添加")]
        StationStatusUseDone,

        [Description("未找到上一站信息")]
        LastNodeIsEmpty,

        [Description("两个出站状态不能同时到同一工站")]
        TwoLinkBindSameNode,

        [Description("只有失败的结果才能回到上一工站")]
        OnlyFailResultToLastNode,

        [Description("出站数据重复")]
        RoutingOutRepeat,

        [Description("出入库类型错误")]
        ErrorWaveHouseType,

        [Description("入库类型错误")]
        ErrorWaveHousingType,

        [Description("审核结果不能为空")]
        BillCheckResultNotNull,

        [Description("调用未指定出入库类型")]
        WaveHouseTypeNotNull,

        [Description("仓库id不能为空")]
        WaveHouseIDNotNull,

        [Description("物料不能为空")]
        InventoryNotNull,

        [Description("供应商或客户id不能为空")]
        BusinessIDNotNull,

        [Description("单号不能为空")]
        BillIDNotNull,

        [Description("原始单号不能为空")]
        RowBillIDNotNull,

        [Description("数量填写有误")]
        CountError,
        [Description("供应商或客户id不存在")]
        BusinessIDNotExist,
        [Description("仓库不存在")]
        WaveHouseIDNotExist,
        [Description("物料不存在")]
        MaterialNotExist,

        [Description("没有此分类的权限")]
        ManageCatOnlyBySuperAdministrator,

        [Description("类型错误")]
        ErrorTraceType,

        [Description("储位编号不能为空")]
        LocationIDNotNull,

        [Description("数量不能为空")]
        CountNotNull,
        
        [Description("数量不足")]
        CountInsufficient,

        [Description("储位错误")]
        LocationError,

        [Description("管理模式与物料不匹配")]
        ManageModeNotMatching,

        [Description("序号已存在")]
        NoExist,
        [Description("库存记录不存在")]
        StockNotExist,

        [Description("使用中无法删除")]
        IsUsedNotDelete,

        [Description("参数不能超过100个字符")]
        ParamLengthTooLong,

        [Description("产品编号-料号-文件已存在")]
        ProductPnFileIsExist,

        [Description("最大值最小值错误")]
        MaxMinError,

        [Description("产品编号-料号-生产线-工站-项目名称已存在")]
        OQCCheckItemAddOrUpdateError,

        [Description("生产线-工站-项目名称已存在")]
        BookItemAddOrUpdateError,

        [Description("SN不存在")]
        SNIsNotExist,

        [Description("工单不存在")]
        WorkOrderIsNotExist,

        [Description("未找到过站状态")]
        StationStatusIsEmpty,

        [Description("工站不能为空")]
        StationIsEmpty,

        [Description("工单号不能为空")]
        WorkOrderIsEmpty,

        [Description("功能不能为空")]
        FunctionsIsEmpty,

        [Description("工单号已存在")]
        WorkOrderIsExsit,

        [Description("使用地点不能为空")]
        UseAddressNotNull,

        [Description("序号不能为空")]
        SNEmpty,

        [Description("最小库存必须小于等于最大库存")]
        MaxMinStockError,

        [Description("库存不能小于零")]
        StcokNotLessThanZero,

        [Description("满箱数量必须大于零")]
        FullQtyMustMoreThanZero,

        [Description("上一工站不能等于工站")]
        LastStationNotEqualCurrentStation,

        [Description("有节点没有设置工站")]
        HaveNodeNotSetStation,

        [Description("产品编号-料号-出货地已存在")]
        ProductNoPnRegionExsit,

        [Description("物料信息有误,单位信息为空")]
        UnitNotFound,

        [Description("部门信息为空")]
        DepartmentNull,

        [Description("当前状态不允许打印")]
        CanNotPrint,

        [Description("类型错误")]
        ErrorPrintType,

        [Description("库存必须是整数")]
        StockMustBeInteger,

        [Description("字典正在使用,不能删除和修改")]
        DictIsUsingDonotBeAlter,

        [Description("当前状态不允许此操作")]
        ErrorState,

        [Description("序号入库失败")]
        GenNoError,

        [Description("批次号不存在")]
        BatchNull,

        [Description("序号不存在")]
        NoNull,

        [Description("保存操作详情失败")]
        SaveTraceError,

        [Description("调用接口发生异常")]
        CallInterfaceError,

        [Description("当前状态不允许反审")]
        UncheckDeny,

        [Description("库存id不能为空")]
        StockIDNotNull,

        [Description("库存记录不属于此仓库")]
        StorageLocationNotMatch,

        [Description("上级分类错误")]
        ParentTypeError,

        [Description("生产线-工站-工位-设备编号已存在")]
        EquipmentPositionDataRepeat,

        [Description("生产线-工站已存在")]
        PrinterSettingDataRepeat,

        [Description("单据号不能为空")]
        BillCodeNotNull,

        [Description("当前状态不允许手动完成")]
        CheckStatuError,

        [Description("请选择子级设备类型！")]
        PleaseSelectMachineType,

        [Description("存在未知记录编号")]
        RecordNull,

        [Description("储位不存在")]
        LocationNull,

        [Description("序号管理数量不得大于1")]
        SNManageCountError,

        [Description("只有加工失败回到上一工站才能设置失败的结果")]
        OnlyBackLastNodeCanbeFailStatus,

        [Description("库存信息不能为空")]
        StockDataNotNull,

        [Description("目标仓库id不能为空")]
        EndWaveHouseID,

        [Description("物料分类或其子类正在使用,无法删除")]
        MaterialTypeUseNotDelete,

        [Description("层数过多")]
        LevelCountError,

        [Description("父物料不存在")]
        ParentPnNotExsit,

        [Description("物料正在使用无法删除")]
        MaterialUseNotDelete,

        [Description("生成单号失败")]
        GenSNError,

        [Description("管理模式异常")]
        ErrorManageModel,

        [Description("调出仓库错误")]
        ReceivingStorageInError,
        [Description("接收仓库错误")]
        ReceivingStorageError,

        [Description("所选父级未找到")]
        NoParentStorageType,

        [Description("已存在其他子级")]
        ExistSonStorageType,
        [Description("此层级已经存在")]
        LevelExist,

        [Description("物料层级错误")]
        ErrorMaterialType,

        [Description("调拨仓与目标仓不能相同")]
        StartEndWavehouseEquals,

        [Description("物料重复")]
        InventoryDuplicate,

        [Description("物料与单据不匹配")]
        InventoryNotMatch,

        [Description("层级过多")]
        StorageType2More,

        [Description("物料错误")]
        MaterialeError,

        [Description("sn绑定数量已经达到上限")]
        SnBindReachTheUpper,

        [Description("开始执行时间必须在计划时间内")]
        PlanTimeError,

        [Description("换算单位错误")]
        ConvertUnitError,

        [Description("产线错误")]
        LineError,

        [Description("工站错误")]
        StationError,

        [Description("工位错误")]
        PositionError,

        [Description("子物料错误")]
        SonPnError,

        [Description("父物料和子物料不能相同")]
        ParentPnNotEqualSonPn,

        [Description("子物料不存在")]
        SonPnNotExsit,

        [Description("父物料数据在清单中不存在")]
        ParentPnNotExistInProductSture,

        [Description("子物料数据在清单中不存在")]
        SonPnNotExistInProductSture,

        [Description("子物料在导入文件中重复")]
        SonPnExistInUploadFile,

        [Description("在导入文件中未找到父物料")]
        ParentPnNotExistInUploadFile,

        [Description("未找到设备驱动")]
        NotFindDriver,

        [Description("设备编号或名称已存在")]
        MachineCodeOrNameIsExsit,

        [Description("结果编号已存在")]
        EventNoIsExsit,

        [Description("结果编号未找到")]
        EventNoNotFind,

        [Description("过站状态未找到")]
        RoutingStatusNotFind,

        [Description("项目名称在字典中未找到")]
        ItemNameNotExsitInDict,

        [Description("维护方式在字典中未找到")]
        CheckTypeNotExsitInDict,

        [Description("出货地在字典中未找到")]
        RegionNotExsitInDict,

        [Description("1->勾选确定型；2->数值记录型 值错误")]
        PlanValueTypeError,

        [Description("上下限错误")]
        UpperLowerError,

        [Description("一直执行/日期范围/次数 值错误")]
        InstructionCycleError,

        [Description("开始执行时间 值错误")]
        StartInstructTimeError,

        [Description("待修改的字段名称不能为空")]
        KeyNotNull,

        [Description("值不能为空")]
        ValueNotNull,

        [Description("值类型错误")]
        ValueError,

        [Description("类别编码已存在")]
        CategoryCodeIsExist,

        [Description("类别名称已存在")]
        CategoryNameIsExist,

        [Description("编号已存在")]
        NumberIsExist,

        [Description("更新库存失败")]
        SyncStockError,

        [Description("该工艺清单已存在")]
        TechnologyIsExist,

        [Description("该工艺清单程序号已存在")]
        TechnologyProgramIsExist,

        [Description("该刀位号已存在")]
        TechToolNumbersExist,

        [Description("工艺单不存在")]
        TechnologyIsNotExist,

        [Description("品名-规格已存在")]
        MaterialNameSpecExist,

        [Description("密码格式错误")]
        PassWordFormatError,

        [Description("旧密码错误")]
        OldPassWordError,

        [Description("料号已存在")]
        PartNoIsExist,

        [Description("设备未配置刀位数量")]
        MachineToolCountNotFound,

        [Description("该刀位不可以再次选择")]
        ToolCannotChoiceAgain,

        [Description("刀具柜编号已存在")]
        ToolStorageNoIsExist,

        [Description("工艺单未找到")]
        TechnologyNotFound,

        [Description("工单未找到")]
        ToolWorkorderNotFound,

        [Description("刀柄编号无效")]
        ToolHandlerInValid=9000349,

        [Description("刀具批次号无效")]
        ToolBatchNumberInValid,

        [Description("有出入库记录不能更改管理模式")]
        MaterialManageModeChangedFail,

        [Description("供应商不匹配")]
        BusinessNotMatch,

        [Description("没有已选择的刀具清单")]
        NoChoiceTools,

        [Description("选择的刀具清单已提交出库")]
        ToolsHasOutStock,

        [Description("没有已组装的刀具")]
        NoPackageTools,

        [Description("该刀具已安装")]
        ToolCannotInstallAgain,

        [Description("测量文件未找到")]
        ToolMeatureFileNotFound,

        [Description("测量文件解析失败")]
        ToolMeatureFileInValid,

        [Description("参数有误")]
        InputValueError,

        [Description("未知")]
        DncCallUnknown,

        [Description("失败，错误")]
        DncCallFailed,

        [Description("离线")]
        DncCallOffLine,

        [Description("请求（命令）参数错误 ")]
        DncCallParameterError,

        [Description("请求超时（web熔断保护）")]
        DncCallOutTime,

        [Description("设备未找到")]
        DncCallMachineNotFound,

        [Description("服务器处理错误")]
        DncCallServerError,

        [Description("（web）客户端请求错误")]
        DncCallClientRequestError,

        [Description("不支持")]
        DncCallDonotSupport,

        [Description("网关服务器处理错误")]
        DncCallGatewayFailed,

        [Description("网关通道未找到")]
        DncCallGatewayNotFound,

        [Description("仓库不存在")]
        StorageError,

        [Description("不允许跨仓库操作")]
        StorageDeny,

        [Description("样本数量不能为空")]
        NumError,

        [Description("产线不能为空")]
        LineNotNull,

        [Description("不良代码已存在")]
        UnhealthyCodeIsExsit,

        [Description("类别不能为空")]
        CategoryNotNull,

        [Description("检验项目不能超过两百字符")]
        InspectItemExceedWordLimit,

        [Description("检验标准不能超过两百字符")]
        InspectStandardExceedWordLimit,

        [Description("不良描述不能超过一千字符")]
        UnhealthyDescExceedWordLimit,

        [Description("不良代码只能是五位的数字或字母")]
        UnhealthyCodeFormatError,

        [Description("该状态下不能修改")]
        CannotUpdate,

        [Description("投入数必须大于零")]
        InputNumNotZero,

        [Description("生产时间不能为空")]
        ProductionTimeNotNull,

        [Description("详情不良数量必须等于总数量")]
        UnHealthyNumSumError,

        [Description("同一检验位置下，产线和检验项目不能重复")]
        InspectItemRepeat,

        [Description("请输入编号")]
        NumberIsEmpty,

        [Description("该状态下不能签收")]
        CannotSignThisDocument,

        [Description("工序未找到")]
        RouteNotFound,

        [Description("请先出库")]
        PleaseOutStock,

        [Description("该刀具未被安装，不可卸载")]
        ToolNotInstall,

        [Description("该刀位未安装刀具，不可卸载")]
        CutterNumberNotInstall,

        [Description("该刀位不可再次安装刀具，请先卸载")]
        MachineCutterHasInstallTool,

        [Description("没有文档可供操作")]
        NoDocumentsForOperate,
       
        [Description("序号错误")]
        SerialNumberError,

        [Description("产品编号不能为空")]
        ProductCodeIsNull,

        [Description("请选择数据")]
        SelectData,

        [Description("产品编号已存在")]
        ProductCodeIsExist,

        [Description("该状态下不能审核")]
        CannotApprovalThisDocument,

        [Description("没有权限审批该文档")]
        HaveNoRightApprove,

        [Description("不能再次审批该文档")]
        CannotApprovalAgain,

        [Description("未找到当前审批步骤")]
        CurrentApprovalStepNotFound,

        [Description("该状态下不能撤回")]
        CannotRecall,

        [Description("该记录不能删除")]
        CannotDelete,

        [Description("未审核通过的文档不能下发")]
        CannotBindThisDocument,

        [Description("该文档不能再次下发")]
        CannotBindingAgain,

        [Description("该文档不能预览")]
        CannotPreviewThisFile,

        [Description("没有权限撤回该文档")]
        NoAuthorityRecall,

        [Description("没有权限签收该文档")]
        NoAuthoritySign,

        [Description("请先进行培训再签收")]
        TrainFirst,

        [Description("库存不足")]
        StockUnEnough,

        [Description("只有最后一级分类才能绑定")]
        OnlyLastLevelCanBind,

        [Description("ID已存在")]
        IdHasExist,

        [Description("工艺信息不存在")]
        ProcessNotFind,

        [Description("生效时间不能为空")]
        EffectDateIsEmpty,

        [Description("请选择用户")]
        UserIsEmpty,

        [Description("请选择设备")]
        MachineIsEmpty,

        [Description("请选择班组")]
        WorkingGroupIsEmpty,

        [Description("此状态已开始")]
        MachineStateHasStarted,

        [Description("此状态未开始")]
        MachineStateNotStarted,

        [Description("有设备未签出")]
        SomeMachineNotSignOut,

        [Description("请选择模块")]
        ModuleIsEmpty,

        [Description("模块无效")]
        ModuleIsInvalid,

        [Description("该产品工艺已存在，不能再次添加")]
        ProductRouteHasexist,

        [Description("必须指定用户或产品")]
        UserOrProductIsRequired,

        [Description("检验位置未找到")]
        InspectLocationNotFound,

        [Description("异常规则未找到")]
        AbnomalRuleNotFound,

        [Description("不良代码未找到")]
        UnhealthyCodeNotFound,

        [Description("控制图类型错误")]
        QmsChartTypeError,

        [Description("不良代码不能为空")]
        UnhealthyCodeIsEmpty,

        [Description("不良名称不能为空")]
        UnhealthyNameIsEmpty,

        [Description("未找到检测室")]
        TestRoomNotFound,

        [Description("已完成后不能再操作")]
        HasCompletedDontOperate,

        [Description("二维码不能重复")]
        SnDontRepeat,

        [Description("已审核过的记录不能再次审核")]
        CannotApplyAgain,

        [Description("请选择检验结果")]
        SelectCheckResult,

        [Description("备件二维码不能为空")]
        SparepartQrCodeCannotEmpty,

        [Description("备件尚未入库")]
        SparepartQrCodeNotInStock,

        [Description("检验项目未找到")]
        CheckItemNotFound,

        [Description("参数类型已存在")]
        ParameterTypeIsExsit,

        [Description("备件代号不能重复")]
        SparepartCodeHasDuplicate,

        [Description("备件代号已存在")]
        SparepartCodeHasExist,

        [Description("参数类型未找到")]
        ParameterTypeNotFound,

        [Description("备件已绑定结构树，无法删除")]
        SparepartCannotDelete,

        [Description("含有子级异常，无法删除")]
        AndonExceptionCannotDelete,

        [Description("同一个人只能属于一个班组")]
        UserWorkGroupHasDuplicate,

        [Description("该工位已设置")]
        SectionHasConfig,

        [Description("不能再次提交备货")]
        SparepartHasPrepare,

        [Description("设备属性不正确")]
        MachineAttributionInValid,

        [Description("失效模式未找到")]
        FaultModeNotFound,

        [Description("请导入相同等级的异常类型")]
        AndonExpectionLevelNotSame,
        [Description("异常类型等级错误")]
        AndonExpectionLevelError,
        [Description("异常类型已存在")]
        AndonExpectionExist,
        [Description("父级异常类型不存在")]
        AndonParentExpectionNotExist,
        [Description("异常推送流程不存在")]
        AndonExpectionProcessNotExist,
        [Description("异常责任岗不存在")]
        AndonExpectionUserGroupNotExist,
        [Description("请填写正确的异常级别")]
        ErrorExpectionLevel,

        [Description("班组名称已存在")]
        WorkingGroupIsExist,

        [Description("相同班组排班必须相同")]
        WorkingGroupIsInvalid,

        [Description("项次重复")]
        ItemSeqExsit,

        [Description("偏差放行数量错误")]
        DeviationReleaseQuantityNotNull,

        [Description("OEE损失异常类型")]
        OEELossType,

        [Description("开始执行日期不能小于当前日期")]
        DateInvalid,

        [Description("请选择损失类型")]
        SelectOEELossType,

        [Description("请选择待接收数据")]
        SelectWaitRecieve,

        [Description("请选择待检验数据")]
        SelectWaitCheck,

        [Description("不是检验中状态不能操作")]
        NotChecking,

        [Description("通道不存在")]
        PassagewayError,

        [Description("模板已存在")]
        TemplateHasExist,

        [Description("该设备无此功能")]
        DncCallMachineIsNotFunction,

        [Description("该程序号已存在，是否继续创建程序？")]
        ProgramIsExist,
        [Description("子级工作模式重复")]
        SelectMachineTypeRepeat,

        [Description("父级工作模式不存在")]
        ParentSelectMachineTypeNull,

        [Description("导入的数据重复")]
        RepeatBoxListCodeExsit,

        [Description("父级工作模式已存在")]
        ParentSelectMachineTypeOk,

        [Description("程序文件未找到")]
        ProgramNotFind,

        [Description("路卡号已存在")]
        ProgramTollGateCodeExsit,

        [Description("检验项目未找到")]
        StandardTypeNull,

        [Description("授权失败")]
        MandateIsFill,

        [Description("换型时间请输入整数")]
        ChangeModelTimeNotInteger,

        [Description("标准节拍请输入整数")]
        CycleTimeNotInteger,

        [Description("日标准产量请输入整数")]
        OutPutNotInteger,

        [Description("产量系数请输入整数")]
        YieldRateNotInteger,

        [Description("上下料节拍请输入整数")]
        UpDownBesatNotInteger,

        [Description("数据库创建失败")]
        CreateDbFailed,

        [Description("数据表创建失败")]
        CreateTablesFailed,

        [Description("标签来源未维护")]
        LableNotMaintain,
        [Description("只能读取txt文件")]
        OnlyTxtFile,
        [Description("程序版本号不能为空")]
        ProGramVersionNotNull,
        [Description("存在相同程序号的程序已审核，是否覆盖原来程序记录？")]
        ProGramCheckIsExist,
        [Description("记录已存在，请删除后添加")]
        AlreadyExists,
        [Description("人员未找到")]
        UserNotExists,
        [Description("默认展示已存在")]
        DefaultDisplayExists,

        [Description("未找到储位类别")]
        LocationTypeNotFound,

        [Description("未找到工装类型")]
        FixtureToolCatgeoryNotFound,

        [Description("未找到工装信息")]
        FixtureToolNotFound,

        [Description("ID重复")]
        IDExist,

        [Description("父级和子级不能相同")]
        ParentSonSame,

        [Description("该类型绑定了工装,不能删除")]
        CategoryBindFixtureToolData,
    }
}
