﻿
namespace Siger.Middlelayer.Common.Log
{
    public class Logger
    {
        private static LogEngine _logEngine;

        public static bool Debug { get; set; }

        public static void RegisterTxtLogEngine(Module module)
        {
            _logEngine = new TxtLogEngine(module);

            WriteLineInfo($"module: {module} has been activated.");
        }

        public static void WriteLineInfo(string msg)
        {
            _logEngine?.Write(LogLevel.Info, msg);
        }

        public static void WriteLineWarn(string msg)
        {
            _logEngine?.Write(LogLevel.Warn, msg);
        }

        public static void WriteLineError(string msg)
        {
            _logEngine?.Write(LogLevel.Error, msg);
        }

        public static void WriteLineVerbose(string msg)
        {
#if DEBUG
            _logEngine?.Write(LogLevel.Verbose, msg);
#endif
        }


        public static void WriteLineDebug(string msg)
        {
#if DEBUG
            _logEngine?.Write(LogLevel.Debug, msg);
#endif
        }
    }
}
