﻿using System;

namespace Siger.Middlelayer.Utility.ExcelImport
{
    [AttributeUsage(AttributeTargets.All)]
    public class ExcelColumn : Attribute
    {
        public string ColumnName { get; set; }

        public ExcelColumn(string name)
        {
            ColumnName = name;
        }
    }
    [AttributeUsage(AttributeTargets.All)]
    public class IsShow:Attribute
    {
        public int No { get; set; }
        public IsShow(int no)
        {
            No = no;
        }
    }

    [AttributeUsage(AttributeTargets.All)]
    public class EmptyValidate : Attribute
    {
        public string ErrorMessage { get; set; }

        public EmptyValidate(string error)
        {
            ErrorMessage = error;
        }
    }

    [AttributeUsage(AttributeTargets.All)]
    public class RegularExpressionValidate : Attribute
    {
        public string RegularExpression { get; set; }

        public string ErrorMessage { get; set; }

        public RegularExpressionValidate(string expression, string error)
        {
            RegularExpression = expression;
            ErrorMessage = error;
        }
    }

    [AttributeUsage(AttributeTargets.All)]
    public class DonnetExportAttribute : Attribute
    {
    }

    [AttributeUsage(AttributeTargets.All)]
    public class DonnetValidateAttribute : Attribute
    {
    }

    [AttributeUsage(AttributeTargets.All)]
    public class DonnetCreateAttribute : Attribute
    {
    }
}
