﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using OfficeOpenXml;
using OfficeOpenXml.Style;
using Siger.Middlelayer.Utility.ExcelImport;
using Siger.Middlelayer.Utility.ImportEntities;
using ExcelColumn = Siger.Middlelayer.Utility.ExcelImport.ExcelColumn;

namespace Siger.Middlelayer.Utility.Helpers
{
    public class EpPlusExcelTemplateHelper
    {
        /// <summary>
        /// create excel file by template
        /// </summary>
        /// <param name="ty"></param>
        /// <param name="filePath"></param>
        public void GenerateTemplate(Type ty,string filePath, int language = 0)
        {
            var file = new FileInfo(filePath);
            var package = new ExcelPackage(file);
            var worksheet = package.Workbook.Worksheets.Add("sheet1");

            try
            {
                //add head
                bool ColumnOnly(CustomAttributeData y) => y.AttributeType == typeof(ExcelColumn);
                var columns = ty
                    .GetProperties()
                    .Where(x => x.CustomAttributes.Any(ColumnOnly)
                                && x.CustomAttributes.All(m => m.AttributeType != typeof(DonnetCreateAttribute)))
                    .Select(p => new
                    {
                        Property = p,
                        Column = (language == 0 || !EpPlusLanguageHelper.LanguageDictionary.ContainsKey(p.GetCustomAttributes<ExcelColumn>().First().ColumnName))
                            ? p.GetCustomAttributes<ExcelColumn>().First().ColumnName
                            : EpPlusLanguageHelper.LanguageDictionary[p.GetCustomAttributes<ExcelColumn>().First().ColumnName]
                    }).ToList();

                for (var i = 0; i < columns.Count; i++)
                {
                    worksheet.Cells[1, i + 1].Value = columns[i].Column;
                    worksheet.Column(i + 1).Width = 18;
                }

                //worksheet.Column(1).Width = 10;
                worksheet.Cells[1, 1].Style.HorizontalAlignment = ExcelHorizontalAlignment.Center;
                worksheet.Cells.Style.ShrinkToFit = true;
                package.Save();
            }
            finally
            {
                package.Dispose();
            }
        }



        /// <summary>
        /// 总体查询导出
        /// </summary>
        /// <param name="Data"></param>
        /// <param name="filePath"></param>
        /// <param name="language"></param>
        public void GenerateAutoCol(List<ImportGeneralObj> Data, string filePath, int language = 0)
        {
            var file =new FileInfo(filePath);
            var package = new ExcelPackage(file);
            var worksheet = package.Workbook.Worksheets.Add("sheet1");

            try
            {
                //add head
                for(var i =0;i <Data.Count;i ++)
                {
                    var heads = Data[i].Head;
                    var items = Data[i].Items;
                    var values = Data[i].Values;
                    if (i == 0)
                    {
                        //head1
                        for (var j = 0; j < heads.Count; j++)
                        {
                            if (j > 0 && heads[j] == heads[j - 1])
                            {
                                worksheet.Cells[1, j + 1].Merge = true;
                            }
                            else
                            {
                                worksheet.Cells[1, j + 1].Value = heads[j];
                            }
                        }
                        //head item
                        for (var h= 0; h < items.Count; h++)
                        {
                            worksheet.Cells[2, h + 1].Value = items[h];
                        }
                    }
                    for(var v=0;v<values.Count;v ++)
                    {
                        worksheet.Cells[3+i, v + 1].Value = values[v];
                    }
                }
                //worksheet.Column(1).Width = 10;
                worksheet.Cells[1, 1].Style.HorizontalAlignment = ExcelHorizontalAlignment.Center;
                worksheet.Cells.Style.ShrinkToFit = true;
                package.Save();
            }
            finally
            {
                package.Dispose();
            }
        }

        public void GenerateTemplateFL(GeneralTrackingSnResultFL gts, string filePath)
        {
            var file = new FileInfo(filePath);
            var package = new ExcelPackage(file);
            var worksheet = package.Workbook.Worksheets["SNTrace"];
            try
            {
                var data = gts.Bodys[0].RowsCols[0];
                worksheet.Cells[3,1].Value = data.Sn;
                worksheet.Cells[3, 2].Value = data.ProductCode;
                worksheet.Cells[3, 3].Value = data.ProductNmae;
                worksheet.Cells[3, 4].Value = data.spec;
                worksheet.Cells[3, 5].Value = data.Line;
                worksheet.Cells[3, 6].Value = data.WO;
                worksheet.Cells[3, 7].Value = data.install_count;
                worksheet.Cells[3, 8].Value = data.ordernumber;
                worksheet.Cells[3, 9].Value = data.quantity;
                worksheet.Cells[3, 10].Value = data.delivery_time;
                var num = 11;
                for (int i = 0; i < gts.Bodys[0].RowsCols.Count; i++)
                {
                    worksheet.Cells[3, num].Value = gts.Bodys[0].RowsCols[i].Items[0].Values;
                    worksheet.Cells[3, num+1].Value = gts.Bodys[0].RowsCols[i].Items[1].Values;
                    worksheet.Cells[3, num+2].Value = gts.Bodys[0].RowsCols[i].Items[2].Values;
                    worksheet.Cells[3, num+3].Value = gts.Bodys[0].RowsCols[i].Items[3].Values;
                    num = num + 4;
                }
                //worksheet.Cells[1, 1].Style.HorizontalAlignment = ExcelHorizontalAlignment.Center;
                worksheet.Cells.Style.ShrinkToFit = true;
                package.Save();
            }
            finally
            {
                package.Dispose();
            }
        }

        /// 总体查询导出
        /// </summary>
        /// <param name="Data"></param>
        /// <param name="filePath"></param>
        /// <param name="language"></param>
        public void GenerateAutoQualificationRate(List<ImportGeneralObj> Data, string filePath, int language = 0)
        {
            var file = new FileInfo(filePath);
            var package = new ExcelPackage(file);
            var worksheet = package.Workbook.Worksheets.Add("sheet1");

            try
            {
                //add head
                for (var i = 0; i < Data.Count; i++)
                {
                    var items = Data[i].Items;
                    var values = Data[i].Values;
                    if (i == 0)
                    {
                        //head item
                        for (var h = 0; h < items.Count; h++)
                        {
                            worksheet.Cells[1, h + 1].Value = items[h];
                        }
                    }
                    for (var v = 0; v < values.Count; v++)
                    {
                        worksheet.Cells[2 + i, v + 1].Value = values[v];
                    }
                }
                worksheet.Cells[1, 1].Style.HorizontalAlignment = ExcelHorizontalAlignment.Center;
                worksheet.Cells.Style.ShrinkToFit = true;
                package.Save();
            }
            finally
            {
                package.Dispose();
            }
        }
        public void Dispose()
        {
            
        }
    }
}
