﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class SeqDetailTemplate : ImportBase
    {
        [ExcelColumn("序号")]
        [EmptyValidate("SnIsEmpty")]
        public string sn { get; set; }

        [ExcelColumn("产品编号")]
        public string productID { get; set; }

        [ExcelColumn("产品名称")]
        public string productname { get; set; }
        [ExcelColumn("工单")]
        public string wo { get; set; }

        [ExcelColumn("生产线")]
        public string line { get; set; }

        [ExcelColumn("工位")]
        public string station { get; set; }

        [ExcelColumn("结果")]
        public string result { get; set; }
        [ExcelColumn("投产时间")]
        public string inputDateTime { get; set; }

        [ExcelColumn("更新时间")]
        public string transDateTime { get; set; }
    }

    public class SeqDetailList : SeqDetailTemplate
    {

    }

    public class SeqDetailByDateTemplate : ImportBase
    {

        [ExcelColumn("序号")]
        public string sn { get; set; }
        [ExcelColumn("生产线")]
        public string Line { get; set; }
        [ExcelColumn("工位")]
        public string Station { get; set; }
        [ExcelColumn("结果")]
        public string Result { get; set; }
        [ExcelColumn("操作人")]
        public string User { get; set; }
        [ExcelColumn("时间")]
        public string TransDateTime { get; set; }
      
    }

    public class SeqDetailByDateList : SeqDetailByDateTemplate
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        public int No { get; set; }
    }

    public class YieldTemplate : ImportBase
    {
        [ExcelColumn("产品代码")]
        public string productid { get; set; }

        [ExcelColumn("生产线")]
        public string line { get; set; }

        [ExcelColumn("工站")]
        public string station { get; set; }

        [ExcelColumn("良品数")]
        public int okcol { get; set; }

        [ExcelColumn("不良品数")]
        public int nocol { get; set; }

        [ExcelColumn("总数")]
        public int total { get; set; }

        [ExcelColumn("良率")]
        public string yeild { get; set; }
    }

    public class YieldList : YieldTemplate
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        public int No { get; set; }
    }

    public class UnhealthyTemplate : ImportBase
    {
        [ExcelColumn("生产线")]
        public string line { get; set; }

        [ExcelColumn("工站")]
        public string station { get; set; }

        [ExcelColumn("不良项目")]
        public string item { get; set; }

        [ExcelColumn("不良数量")]
        public int qty { get; set; }

        [ExcelColumn("开始时间")]
        public string BeginDateTime { get; set; }

        [ExcelColumn("结束时间")]
        public string EndDateTime { get; set; }

        [ExcelColumn("录入人")]
        public string username { get; set; }

        [ExcelColumn("录入时间")]
        public string TransDateTime { get; set; }
    }

    public class UnhealthyList : UnhealthyTemplate
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        public int No { get; set; }
    }

    public class WipTemplate : ImportBase
    {
        [ExcelColumn("生产线")]
        public string line { get; set; }

        [ExcelColumn("工站")]
        public string station { get; set; }

        [ExcelColumn("数量")]
        public int qty { get; set; }
    }

    public class WipList : WipTemplate
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        public int No { get; set; }
    }

    public class WipDetailTemplate : ImportBase
    {
        [ExcelColumn("序列号")]
        public string sn { get; set; }

        [ExcelColumn("工单")]
        public string wo { get; set; }

        [ExcelColumn("料号")]
        public string pn { get; set; }

        [ExcelColumn("当前工站")]
        public string station { get; set; }

        [ExcelColumn("结果")]
        public string result { get; set; }

        [ExcelColumn("投入时间")]
        public string transdatetime { get; set; }
    }

    public class WipDetailList : WipDetailTemplate
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        public int No { get; set; }
    }

    public class DefectiveTemplate : ImportBase
    {
        [ExcelColumn("序列号")]
        public string sn { get; set; }

        [ExcelColumn("工单")]
        public string wo { get; set; }

        [ExcelColumn("料号")]
        public string pn { get; set; }

        [ExcelColumn("当前工站")]
        public string station { get; set; }

        [ExcelColumn("不良信息")]
        public string result { get; set; }

        [ExcelColumn("投入时间")]
        public string transdatetime { get; set; }
    }

    public class DefectiveList : DefectiveTemplate
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        public int No { get; set; }
    }

    public class TraceDtlTempleate:ImportBase
    {

        [ExcelColumn("序号")]
        [EmptyValidate("SnIsEmpty")]
        public string sn { get; set; }

        [ExcelColumn("项目")]
        [EmptyValidate("itemIsEmpty")]
        public string item { get; set; }

        [ExcelColumn("值")]
        [EmptyValidate("valueIsEmpty")]
        public string value { get; set; }

        [ExcelColumn("结果")]
        [EmptyValidate("ResultIsEmpty")]
        public string result { get; set; }

        [ExcelColumn("时间")]
        [EmptyValidate("updatedateIsEmpty")]
        public string transdate { get; set; }

    }
}
