﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class AlarmInfoList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        public int No { get; set; }

        /// <summary>
        /// 设备名称
        /// </summary>
        [ExcelColumn("设备名称")]
        public string Name { get; set; }

        /// <summary>
        /// 设备编号
        /// </summary>
        [ExcelColumn("设备编号")]
        public string Code { get; set; }

        /// <summary>
        /// 程序号
        /// </summary>
        [ExcelColumn("程序号")]
        public string ProgramNo { get; set; }

        /// <summary>
        /// 主轴号
        /// </summary>
        [ExcelColumn("主轴号")]
        public string SpindleNo { get; set; }

        /// <summary>
        /// 刀位号
        /// </summary>
        [ExcelColumn("刀位号")]
        public string ToolNo { get; set; }

        /// <summary>
        /// 刀位号
        /// </summary>
        [ExcelColumn("已使用寿命")]
        public int Usage { get; set; }

        /// <summary>
        /// 报警内容
        /// </summary>
        [ExcelColumn("报警内容")]
        public string AlarmContent { get; set; }

        /// <summary>
        /// 报警时间
        /// </summary>
        [ExcelColumn("报警时间")]
        public string AlarmTime { get; set; }
    }
}
