﻿using System;
using System.Collections.Generic;
using System.Text;
using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class AndonErrorSummary : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("横坐标")]
        public string Abscissa { get; set; }

        [ExcelColumn("异常时长(分钟)")]
        public double ErrorHour { get; set; }

        [ExcelColumn("异常次数")]
        public double ErrorCount { get; set; }

        [ExcelColumn("平均响应时长(分钟)")]
        public double AverageResponseHours { get; set; }

        [ExcelColumn("平均处理时长(分钟)")]
        public double AverageHandleHours { get; set; }

        [ExcelColumn("异常占比")]
        public double ErrorPercent { get; set; }
    }

    public class AndonOee : ImportBase
    {
        /// <summary>
        /// 通道
        /// </summary>
        [ExcelColumn("通道")]
        public string sectionName { get; set; }
        /// <summary>
        /// 损失类型
        /// </summary>
        [ExcelColumn("损失类型")]
        public string type_name { get; set; }
        /// <summary>
        /// 二级类型
        /// </sumdan
        [ExcelColumn("二级类型")]
        public string expection2 { get; set; } = "";
        /// <summary>
        /// 三级类型
        /// </summary>
        [ExcelColumn("三级类型")]
        public string expection3 { get; set; } = "";
        /// <summary>
        /// 责任岗位
        /// </summary>
        [ExcelColumn("责任岗位")]
        public string usergroup_name { get; set; } = "";
        [ExcelColumn("开始时间")]
        public string str_startTime { get; set; }
        [ExcelColumn("结束时间")]
        public string str_endTime { get; set; }
        /// <summary>
        /// 损失时长
        /// </summary>
        [ExcelColumn("损失时长（秒）")]
        public double subtraction { get; set; }
        [ExcelColumn("工单号")]
        public string workOrderId { get; set; }
        /// <summary>
        /// 修改人
        /// </summary>
        [ExcelColumn("修改人")]
        public string editor_name { get; set; } = "";
        /// <summary>
        /// 修改时间
        /// </summary>
        [ExcelColumn("修改时间")]
        public string rel_edit_time { get; set; }
    }

    public class OeeStatisticalTable : ImportBase
    {
        [ExcelColumn("通道/日期")]
        public string name { get; set; }

        [ExcelColumn("OEE")]
        public double rate { get; set; }
    }

    public class OeeLossTable : ImportBase
    {
        [ExcelColumn("损失类型/日期/产线/异常类型")]

        public string name { get; set; }
        [ExcelColumn("损失开始时间")]

        public DateTime start { get; set; }
        [ExcelColumn("损失结束时间")]

        public DateTime end { get; set; }
        [ExcelColumn("损失时长")]

        public double loss { get; set; }
    }
}
