﻿using Siger.Middlelayer.Utility.ExcelImport;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    /// <summary>
    /// 包装信息
    /// </summary>
    public class ImportPackage :  ImportBase
    {

        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("箱号")]
        public string BoxId { get; set; }

        [ExcelColumn("产品编号")]
        public string ProductCode { get; set; }

        [ExcelColumn("零件号")]
        public string Pn { get; set; }

        [ExcelColumn("数量")]
        public int Count { get; set; }

        [ExcelColumn("重量")]
        public double Weight { get; set; }

        [ExcelColumn("供应商")]
        public string Suppler { get; set; }

        [ExcelColumn("生产日期")]
        public string Busidate { get; set; }

        [ExcelColumn("生产批次")]
        public string Batch { get; set; }

        [ExcelColumn("发货人中文名")]
        public string SendCh { get; set; }

        [ExcelColumn("发货人英文名")]
        public string SendEn { get; set; }


        [ExcelColumn("收货人中文名")]
        public string ReciveCh { get; set; }

        [ExcelColumn("收货人英文名")]
        public string ReciveEn { get; set; }

        [ExcelColumn("是否翻箱")]
        public string IsOpen { get; set; }

    }

    /// <summary>
    /// 包装二维码明细
    /// </summary>
    public class ImportPackageDetails : ImportBase
    {
        [ExcelColumn("序号")]
        public int No { get; set; }

        [ExcelColumn("箱号")]
        public string BoxId { get; set; }

        [ExcelColumn("工件二维码")]
        public string SN { get; set; }
    }
}
