﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class MaterialTypeList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        public int No { get; set; }

        [ExcelColumn("类别名称")]
        [EmptyValidate("NameIsEmpty")]
        public string Name { get; set; }

        [ExcelColumn("上级类别")]
        [EmptyValidate("ParentTypeIsEmpty")]
        public string ParentType { get; set; }

        [ExcelColumn("简码")]
        [EmptyValidate("TcodeIsEmpty")]
        public string Tcode { get; set; }
    }

    public class MaterialTypeTemplate : ImportBase
    {
        [ExcelColumn("类别名称")]
        [EmptyValidate("NameIsEmpty")]
        public string Name { get; set; }

        [ExcelColumn("上级类别")]
        [EmptyValidate("ParentTypeIsEmpty")]
        public string ParentType { get; set; }

        [ExcelColumn("简码")]
        [EmptyValidate("TcodeIsEmpty")]
        public string Tcode { get; set; }
    }
}
