﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class ProductList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }

        [ExcelColumn("产品名称")]
        [EmptyValidate("ProductNameIsEmpty")]
        public string Name { get; set; }

        [ExcelColumn("产品编号")]
        [EmptyValidate("ProductCodeIsEmpty")]
        public string Code { get; set; }

        [ExcelColumn("产品图纸号")]
        [EmptyValidate("ProductDrawCodeIsEmpty")]
        public string DrawingCode { get; set; }

        [ExcelColumn("产品备注")]
        public string Remark { get; set; }
    }
}
