﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class StandardParts : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }
        [ExcelColumn("检验设备")]
        public string MachineName { get; set; }
        [ExcelColumn("标定频率(分钟)")]
        public double Frequency { get; set; }
        [ExcelColumn("是否启用(0->否;1->是)")]
        public int Enable { get; set; }
        [ExcelColumn("维护人")]
        public string UpdateUser { get; set; }
        [ExcelColumn("维护时间")]
        public string UpdateTime { get; set; }
    }

    public class StandardPartsSn : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetValidate]
        [DonnetCreate]
        public int No { get; set; }
        [ExcelColumn("产品编号")]
        public string ProductCode { get; set; }
        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }
        [ExcelColumn("物料编号")]
        public string MaterialPn { get; set; }
        [ExcelColumn("物料名称")]
        public string MaterialName { get; set; }
        [ExcelColumn("物料规格")]
        public string MaterialSpec { get; set; }
        [ExcelColumn("二维码")]
        public string Sn { get; set; }
        [ExcelColumn("维护人")]
        public string UpdateUser { get; set; }
        [ExcelColumn("维护时间")]
        public string UpdateTime { get; set; }
    }
}
