﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class TechToolList : ImportBase
    {
        /// <summary>
        /// 刀位号
        /// </summary>
        [ExcelColumn("刀位号")]
        public string CutterNumber { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }

        /// <summary>
        /// 工序
        /// </summary>
        [ExcelColumn("工序")]
        public string Route { get; set; }

        /// <summary>
        /// 刀具类别
        /// </summary>
        [DonnetValidate]
        [DonnetCreate]
        [ExcelColumn("类别")]
        public string ToolCategory { get; set; }

        /// <summary>
        /// 物料名称
        /// </summary>
        [DonnetValidate]
        [DonnetCreate]
        [ExcelColumn("物料名称")]
        public string MaterialName { get; set; }

        /// <summary>
        /// 物料名称
        /// </summary>
        [ExcelColumn("料号")]
        public string PartNo { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        [DonnetValidate]
        [DonnetCreate]
        [ExcelColumn("供应商")]
        public string Supplier { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        [ExcelColumn("数量")]
        public string Quantity { get; set; }

        /// <summary>
        /// 伸出长
        /// </summary>
        [ExcelColumn("伸出长")]
        public string ReachLength { get; set; }

        /// <summary>
        /// 上公差
        /// </summary>
        [ExcelColumn("上公差")]
        public string UpperTolerance { get; set; }

        /// <summary>
        /// 下公差
        /// </summary>
        [ExcelColumn("下公差")]
        public string DownTolerance { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        [ExcelColumn("备注")]
        public string Remark { get; set; }

        /// <summary>
        /// 额定寿命
        /// </summary>
        [ExcelColumn("额定寿命")]
        public string RatedLife { get; set; }

        /// <summary>
        /// 刀具号
        /// </summary>
        [ExcelColumn("刀具号")]
        public string ToolCode { get; set; }
    }

    public class TechMouldList : ImportBase
    {
        /// <summary>
        /// 腔模号
        /// </summary>
        [ExcelColumn("腔模号")]
        public string CutterNumber { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }

        /// <summary>
        /// 工序
        /// </summary>
        [ExcelColumn("工序")]
        public string Route { get; set; }

        /// <summary>
        /// 刀具类别
        /// </summary>
        [DonnetValidate]
        [DonnetCreate]
        [ExcelColumn("类别")]
        public string ToolCategory { get; set; }

        /// <summary>
        /// 物料名称
        /// </summary>
        [DonnetValidate]
        [DonnetCreate]
        [ExcelColumn("物料名称")]
        public string MaterialName { get; set; }

        /// <summary>
        /// 物料名称
        /// </summary>
        [ExcelColumn("料号")]
        public string PartNo { get; set; }

        /// <summary>
        /// 供应商
        /// </summary>
        [DonnetValidate]
        [DonnetCreate]
        [ExcelColumn("供应商")]
        public string Supplier { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        [ExcelColumn("数量")]
        public string Quantity { get; set; }

        ///// <summary>
        ///// 伸出长
        ///// </summary>
        //[ExcelColumn("伸出长")]
        //public string ReachLength { get; set; }

        ///// <summary>
        ///// 上公差
        ///// </summary>
        //[ExcelColumn("上公差")]
        //public string UpperTolerance { get; set; }

        ///// <summary>
        ///// 下公差
        ///// </summary>
        //[ExcelColumn("下公差")]
        //public string DownTolerance { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        [ExcelColumn("备注")]
        public string Remark { get; set; }

        /// <summary>
        /// 额定寿命
        /// </summary>
        [ExcelColumn("额定寿命")]
        public string RatedLife { get; set; }

        /// <summary>
        /// 模具号
        /// </summary>
        [ExcelColumn("模具号")]
        public string ToolCode { get; set; }
    }
}
