﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class TechnologyList : ImportBase
    {
        /// <summary>
        /// 产品名称
        /// </summary>
        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }

        /// <summary>
        /// 设备名称
        /// </summary>
        [ExcelColumn("设备名称")]
        public string MachineType { get; set; }

        /// <summary>
        /// 零件图号
        /// </summary>
        [ExcelColumn("零件图号")]
        public string DrawCode { get; set; }

        /// <summary>
        /// 工序名称
        /// </summary>
        [ExcelColumn("工序名称")]
        public string Route { get; set; }

        /// <summary>
        /// 程序号
        /// </summary>
        [ExcelColumn("程序号")]
        public string Program { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        [ExcelColumn("备注")]
        public string Remark { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        [DonnetCreate]
        [DonnetValidate]
        [ExcelColumn("创建人")]
        public string Creator { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        [DonnetCreate]
        [DonnetValidate]
        [ExcelColumn("创建时间")]
        public string Create_Time { get; set; }
    }
}
