﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class BasketlistRepository : AccRepositoryBase<SigerTrBasketlist>, IBasketlistRepository
    {
        private ApiAccDbContext accDbContext;
        public BasketlistRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public IPagedCollectionResult<BasketList> GetBasketlistPagedList(string number, int projectid, int page, int pagesize)
        {
            Expression<Func<BasketList, bool>> FunNum = f => true;
            var query = from s in accDbContext.siger_tr_basketlist
                        join p in accDbContext.siger_tr_basketful_position on s.traceId equals p.traceid
                        select new BasketList
                        {
                            id=s.id,
                             BasketNumber=s.number,
                             Count=s.count,
                             WorkCode=p.workcode,
                             PrdNumber=p.productbh,
                             PrdtName=p.productname,
                             ModelType=p.producttype,
                             OrderCode=p.orderno
                        };
            if (!string.IsNullOrEmpty(number))
            {
                FunNum = q => q.BasketNumber.Contains(number);
            }
            var entities = query.Where(FunNum).OrderByDescending(q => q.id).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            var totalCount = query.Where(FunNum).Count();
            return new PagedCollectionResult<BasketList>(entities, totalCount);

        }
    }
}
