﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.Common;
using System.Linq;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    internal class CheckSnListRepository : AccRepositoryBase<siger_check_sn_list>, ICheckSnListRepository
    {
        private readonly ApiAccDbContext _context;
        public CheckSnListRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public SigerTrRoutingEventNo GetEventNoByResult(string result, int projectId)
        {
            return _context.siger_tr_routing_eventno.FirstOrDefault(t => t.projectId == projectId &&
                t.status == (int)RowState.Valid && t.Descr == result);
        }

        public SigerTrRoutingOutStation GetOutStationByEventNo(int eventno, int sectionId, int projectId)
        {
            return _context.siger_tr_routing_outstation.FirstOrDefault(t => t.projectId == projectId &&
                t.status == (int)RowState.Valid && t.EventNo == eventno && t.Station == sectionId);
        }
    }
}
