﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;
using System.Collections.Generic;
using static Siger.Middlelayer.Share.Enum.ModuleEnum.Automation;
namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface IAutomationTaskListRepository : IAccRepositoryBase<siger_automation_task_list>
    {
        string CrateTaskNumber(TaskTrigerType trigerType);


        /// <summary>
        /// 上下料时候是否能创建任务
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="section"></param>
        /// <returns></returns>
        bool CanTask(int projectId,int section);

        /// <summary>
        /// 创建随机工件号码 SN
        /// </summary>
        /// <returns></returns>
        string CreateRandonSn(string productCode);


        IPagedCollectionResult<ResponseAutomationTasklist> GetTasklistPagedList(List<int> sections, int taskType, string productCode, string TaskNo, string sn, int status, int actionType, string tiggertime, string comptime, int projectid, int page, int pagesize);
    }
}
