﻿using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISigerEquipmentPosition: IAccRepositoryBase<SigerTrEquipmentPosition>
    {
        PagedCollectionResult<EquipmentPosition> GetPagedList(int line, int station, int position, int projectid, int page, int pagesize);

        IEnumerable<EquipmentPosition> GetDataList(int line, int station, int position, int projectid);

        CommonImportResult ImportEquipmentPosition(IEnumerable<EquipmentPositionTemplate> eps, int projectid, int uid);
    }
}
