﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISigerProductReport : IAccRepositoryBase<SigerTrProductReport>
    {
        /// <summary>
        /// 获取未报工信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="station"></param>
        /// <param name="machine"></param>
        /// <param name="workcode"></param>
        /// <param name="number"></param>
        /// <param name="bUnReport"></param>
        /// <returns></returns>
        List<WorkReportInfo> GetUnReport(int projectId, int station,int machine,string workcode="",string number="", bool bUnReport = false);

        /// <summary>
        /// 获取转框信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="number"></param>
        /// <param name="reportKey">report 主键</param>
        /// <returns></returns>
        List<WorkReportInfo> GetWorkByBasketNum(int projectId,string number,string reportKey);

        /// <summary>
        /// 根据单号获取上料信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="machineCode"></param>
        /// <param name="workCode"></param>
        /// <returns></returns>
        List<WorkReportInfo> GetWorkByWorkCode(int projectId, string machineCode, string workCode);
        /// <summary>
        /// 获取最近上料/报工 信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="parentId">产线层级 父级</param>
        /// <param name="levelId">产线层级最后一级</param>
        /// <returns></returns>
        List<WorkReportInfo> GetReportInfos(int projectId,int parentId, int levelId);

        List<MouldReport> GetMouldReports(int projectId, string serinum, int page=1, int pageSize=10);

        IEnumerable<siger_project_user> GetUserlist(int project);

        List<BasketReport> GetBasketReports(int projectId, int productId, string orderNum, string workCode,int section,string userId,int machineId,DateTime begin,DateTime end, out int totalCount, int page=1,int pageSize=10);

        List<WorkReportInfo> GetDataByWorkCode(int projectId, string workCode);

        List<WorkReportInfo> GetDataDtlByWorkCode(int projectId, string workCode);

        List<WorkReportInfo> GetDataByDate(int projectId,DateTime begin ,DateTime end);

        List<WorkReportInfo> GetDataByDate(int projectId, DateTime begin, DateTime end,List<int>sections);

        siger_user GetUser(int mid);

        WorkPlan GetWorkPlan(int projectId,string workCode);

        IEnumerable<int> GetSonLevelSectionIds(int sectionId, int projectId);

        WorkCodePlanInfo GetPlanInfo(string wrokCode, int project);

        IPagedCollectionResult<BasketOperateInfo> GetBasketOperateList(string productbh, List<int> position,string orderno,string workcode,string machineCode,string basketNo
            ,int uid,int status,DateTime begin,DateTime end,int projectid, int page, int pagesize, int reportstatus = 0, int type = 0);
        IEnumerable<BasketOperate> GetBasketOperateByBasketNo(int condiId, string basketno, int projectId);
    }
}
