﻿using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using System.Threading.Tasks;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISigerTrSnTraceRepository : IAccRepositoryBase<SigerTrSnTrace>
    {
        IEnumerable<ResponseSnTrace> GetCountList(string productid, int line, string starttime, string endtime, int projectid);

        IPagedCollectionResult<SNTraceInfo> GetTrSNTracePagedList(IEnumerable<int> stations, string productID, string sn, DateTime startTime, DateTime endTime, string pn, string result);

        IEnumerable<int> GetSonLevelSectionIds(int sectionId, int projectId);

        /// <summary>
        /// sn 按时间查询 过站记录 
        /// </summary>
        /// <param name="sn"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="projectId"></param>
        /// <param name="productId"></param>
        /// <param name="line"></param>
        /// <param name="station"></param>
        /// <param name="pn"></param>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="evenNo"></param>
        /// <returns></returns>
        Task<IPagedCollectionResult<ResponseSNRptStation>> TrSNTraceDateRtpPagedList(string sn, DateTime startTime, DateTime endTime, int projectId, string productId, int line, int station, string pn, int page = 1, int pagesize = 10, EvenNoEnum evenNo = EvenNoEnum.Default);
        Task<List<ResponseSNRptStation>> TrSNTraceDateRtpPagedList(List<string> sns, int projectId);
        Task<IEnumerable<SnTraceInfo>> GetSnData(List<string> snlist);

        Task<IPagedCollectionResult<SigerTrSnList>> GetRework(Expression<Func<SigerTrSnList, bool>> FunCond, int page, int pagesize);

        bool SaveCncReport(siger_project_product_report entity);
        bool UpdCncReport(siger_project_product_report entity);

        IPagedCollectionResult<ResponseTrSnObj> GetTrTracePagedList(string sn, List<int> staions, List<string> attr, int projectId, DateTime begin, DateTime end, int page, int pageSize);


    }
}
