﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Data;
using Siger.Middlelayer.Repository.Paged;
using System.Threading.Tasks;
namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface ISnListRepository : IAccRepositoryBase<SigerTrSnList>
    {
        IEnumerable<SnList> GetCountList(int line, int station, int projectid, DateTime begin, DateTime end);
        IPagedCollectionResult<SnList> GetPagedList(int line, int station, int projectid, int page, int pagesize);
        IEnumerable<SnList> GetDataList(int line, int station, int projectid);
        IEnumerable<SigerTrSnList> GetDataBySn(string SN, int projectId);
        IEnumerable<siger_tr_assist_materials> GetDataByBatch(string batch,string wo, int projectId);
        IEnumerable<RequestMaterial> GetDataWorkOrder(int projectId);
        IEnumerable<ResponseWoInfo> GetWoInfo(string sn, int projectId);

        IPagedCollectionResult<RequestMaterials> GetDataAssistMaterials(RequestAssistMaterials batch, int projectId);
        Task<IPagedCollectionResult<ResponseSNRpt>> SnListRptDatePagedList(string sn,DateTime begin,DateTime end, int projectid,string product,int line,string pn, int page, int pagesize);
        Task<IPagedCollectionResult<ResponseSNRpt>> SnListRptDatePagedList(RequestQuerySnData condition, int projectid);
        IPagedCollectionResult<ResponseFlowCard> GetFlowCards(int projectId, string productCode, string woType, string wo, int page, int pageSize);
    }
}
