﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.EntityFrameworkCore;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerBaseSettingRepository : AccRepositoryBase<SigerTrBaseSetting>, ISigerBaseSetting
    {
        private ApiAccDbContext accDbContext;
        public SigerBaseSettingRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public IEnumerable<SigerTrBaseSetting> GetDataList(int fromline, int toline, int projectid)
        {
            var basesettings =
                accDbContext.siger_tr_station_base_setting.Where(q => q.status == (int)RowState.Valid && q.projectId == projectid);
            var query = from a in basesettings
                        join b in accDbContext.siger_project_level_section
                        on fromline equals b.parentid
                        join c in accDbContext.siger_project_level_section
                        on toline equals c.parentid
                        where b.title == c.title && a.Line == fromline
                        select new SigerTrBaseSetting
                        {
                            Line = toline,
                            Station = c.id,
                            GroupName = a.GroupName,
                            Item = a.Item,
                            Value = a.Value,
                            Seq = a.Seq
                        };

            var entities = query.OrderByDescending(q => q.id).AsNoTracking().ToList();
            return entities;
        }

        public IEnumerable<SigerTrBaseSetting> GetDataBySeq(BaseSettingEnum seq, int projectId, int? station = null)
        {
            Func<SigerTrBaseSetting, bool> FuncStation = f => true;
            var result = from t in accDbContext.siger_tr_station_base_setting
                         where t.Seq == (int)seq && t.projectId == projectId && t.status != (int)RowState.Invalid
                         select t;
            if (station != null)
                FuncStation = f => f.Station == station;
            var data = result.Where(FuncStation).OrderByDescending(o => o.id);
            return data;
        }
        /// <summary>
        /// 获取站别功能
        /// </summary>
        /// <param name="station"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        public IEnumerable<BaseItemSetting>GetBaseItemSettings(int station,int projectId)
        {
            var result = from s in accDbContext.siger_tr_station_base_setting
                         join si in accDbContext.siger_tr_station_base_setting_item on s.Seq equals si.Seq
                         join ls in accDbContext.siger_project_level_section on s.Line equals ls.id
                         join ls2 in accDbContext.siger_project_level_section on s.Station equals ls2.id
                         where s.projectId==si.projectId && s.projectId==ls.projectid && s.projectId ==ls2.projectid &&
                         s.projectId == projectId && s.Station ==station && s.status != (int)RowState.Invalid
                         select new BaseItemSetting {
                              Line=ls.id,
                              LineDesc=ls.title,
                              Staion=ls2.id,
                              StaionDesc=ls2.title,
                              Seq=si.Seq,
                              Desc=si.Descr
                         };
            return result.ToList();
        }
    }
}
