﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerRoutingStationRptRepository : AccRepositoryBase<SigerTrRoutingStaion>, ISigerRoutingStationRpt
    {
        private ApiAccDbContext accDbContext;
        public SigerRoutingStationRptRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }
        /// <summary>
        /// 获取工站报表路由
        /// </summary>
        /// <param name="line"></param>
        /// <param name="productCode"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        public IEnumerable<HeaderStation> GetReportRouteHeader(int line, string productCode, int projectId)
        {
            var query = from r in accDbContext.siger_tr_routing_staion
                        join l in accDbContext.siger_project_level_section on r.Station equals l.id
                        where r.projectId == projectId &&  r.Line== line &&
                        r.status == (int)RowState.Valid && l.status == (int)RowState.Valid 
                        select new HeaderStation{
                            Seq=r.Line,
                            Station= r.Station,
                            Title= l.title
                        };
            return query.OrderBy(o => o.Seq).ToList();
          
        }

        /// <summary>
        /// 获取工站报表路由
        /// </summary>
        /// <param name="line"></param>
        /// <param name="productCode"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        public IEnumerable<HeaderStation> GetReportRouteHeaders(int line, string productCode, int projectId)
        {
            var query = from r in accDbContext.siger_tr_routing_staion
                        join l in accDbContext.siger_project_level_section on r.Station equals l.id
                        where r.projectId == projectId && r.Line == line &&
                        r.status == (int)RowState.Valid && l.status == (int)RowState.Valid 
                        orderby r.Line,r.id
                        select new HeaderStation
                        {
                            Seq = r.Line,
                            Station = r.Station,
                            Title = l.title
                        };
            return query.ToList();

        }
    }
}
