﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Paged;
using System;
using System.Collections.Generic;
using System.Linq.Expressions;
using System.Text;
using System.Linq;
using OfficeOpenXml.FormulaParsing.Excel.Functions.DateTime;
using Siger.Middlelayer.Repository.Extensions;
using Microsoft.EntityFrameworkCore;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrAssembRepository : AccRepositoryBase<siger_tr_assemb_details>, ISigerTrAssembRepository
    {
        private ApiAccDbContext accDbContext;
        public SigerTrAssembRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public IPagedCollectionResult<ResponseAssemb> GetAssembPagedList(string sn, List<int> stations, DateTime begin, DateTime end, int projectid, int page, int pagesize)
        {
            Expression<Func<ResponseAssemb, bool>> funSn = f => true;
            Expression<Func<ResponseAssemb, bool>> funPn = f => true;
            Expression<Func<ResponseAssemb, bool>> funDate = f => true;

            var query = from m in accDbContext.siger_tr_assemb_details
                        join u in accDbContext.siger_project_user on m.uid equals u.mid into temp
                        from us in temp.DefaultIfEmpty()
                        where m.projectId == projectid && stations.Contains(m.section) 
                        select new ResponseAssemb
                        {
                           Sn=m.ispart==0?m.sn:"",
                           Sn2=m.ispart==1? m.sn:"",
                           SnStr=m.sn,
                           Name=m.name,
                           Section=m.section,
                           DateTime=m.busidate,
                           User=us!=null?us.name:""
                        };
            //Sn 不为空时 与时间无关
            if (!string.IsNullOrEmpty(sn))
                funSn = f => f.SnStr.Contains(sn);
            else
                funDate = f => f.DateTime >= begin && f.DateTime <= end;

            var predicate = funSn.And(funPn).And(funDate);

            var entities = query.Where(predicate).OrderByDescending(d=>d.DateTime).Skip((page - 1) * pagesize).Take(pagesize).AsNoTracking().ToList();
            var totalCount = query.Where(predicate).Count();
            return new PagedCollectionResult<ResponseAssemb>(entities, totalCount);
        }

        public IEnumerable<ResponseAssemb>GetAssembs(int section,string sn)
        {
            var query = from q in accDbContext.siger_tr_assemb_details
                        join q2 in accDbContext.siger_tr_assemb_details on q.guid equals q2.guid into temp
                        from p in temp.DefaultIfEmpty()
                        where q.section==section && sn.Contains(q.sn)
                        select new ResponseAssemb
                        {
                            Sn = q.ispart == 0 ? q.sn : "",
                            Sn2 = q.ispart == 1 ? q.sn : "",
                            Name=q.name==null?"":q.name,
                            DateTime=q.busidate
                        };
            return query.ToList();


        }
    }
}
