﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Repository.Extensions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Text;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrAssistMaterialsRepository: AccRepositoryBase<siger_tr_assist_materials>, ISigerTrAssistMaterialsRepository
    {
        private readonly ApiAccDbContext _context;
        public SigerTrAssistMaterialsRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public IEnumerable<RequestName> GetDataByName(RequestGetName ass)
        {
            var res = new List<RequestName>();
            var query = from a in _context.siger_tr_assist_materials
                        select a;
            Expression<Func<siger_tr_assist_materials, bool>> FunWo = f => true;
            Expression<Func<siger_tr_assist_materials, bool>> FunName = f => true;
            if (!string.IsNullOrEmpty(ass.wo))
                FunWo = f => f.wo.Equals(ass.wo);
            if (!string.IsNullOrEmpty(ass.name))
                FunName = f => f.name.Contains(ass.name);
            var queryCondition = FunWo.And(FunName);
            var resultList = query.Where(queryCondition).ToList();

            if (resultList != null&& resultList.Count>0)
            {
                foreach (var item in resultList)
                {
                    var result = new RequestName
                    {
                        id = item.id,
                        name = item.name,
                        pn=item.pn
                    };
                    if (!res.Exists(s => s.pn == item.pn))
                    {
                        res.Add(result);
                    }
                }
            }
            return res.Distinct();
        }
    }
}
