﻿using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrPackBoxListRepository : AccRepositoryBase<SigerTrPackBoxList>, ISigerTrPackBoxListRepository
    {
        private ApiAccDbContext accDbContext;
        public SigerTrPackBoxListRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public SigerTrPackBoxList GetDataByBoxId(string boxId, int projectId)
        {
            return accDbContext.siger_tr_pack_box_list.Where(f => f.BoxID == boxId && f.projectId == projectId && f.status != (int)RowState.Invalid)
                .OrderByDescending(o => o.id).FirstOrDefault();
        }
    }
}
