﻿using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrReworkBindSerialRepository : AccRepositoryBase<SigerTrReworkBindSerial>, ISigerTrReworkBindSerialRepository
    {
        private ApiAccDbContext accDbContext;
        public SigerTrReworkBindSerialRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public siger_project_level_section GetLevelSectionById(int id, int projectid)
        {
            return accDbContext.siger_project_level_section.FirstOrDefault(t => t.id == id && t.projectid == projectid && t.status == (int)RowState.Valid);
        }
    }
}
