﻿using Siger.Middlelayer.Common.ModuleEnum;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Siger.Middlelayer.AccRepository.Request
{
    public class RequestAddSerinumCfg : RequestUpdateSeriumCfg
    {
        [Description("产品编号")]
        public string productId { get; set; }
        [Description("规则说明")]
        public int ruleType { get; set; }
        [Description("顺序")]
        [Required(ErrorMessage ="顺序是必填的")]
        [Range(0, 100)]
        public int step { get; set; }
        [Description("编码类型")]
        public int codeType { get; set; }
        [Description("编码格式")]
        public string codeFormat { get; set; }
        [Description("位数")]
        [Range(0,100)]
        [Required(ErrorMessage = "长度不能为空值")]
        public int length { get; set; }
        [Description("编码值")]
        public string codeValue { get; set; }
        
    }
}
