﻿using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.AccRepository.Request
{
    public class RequestAddAssemblyMaintenance
    {
        [Required(ErrorMessage = "lineNotNull")]
        public int line { get; set; }
        [Required(ErrorMessage = "stationNotNull")]
        public int station { get; set; }
        [Required(ErrorMessage = "编号不能为空")]
        public string serial_number { get; set; }
        [Required(ErrorMessage = "父物料不能为空")]
        public string parent_serial { get; set; }
        [Required(ErrorMessage = "子物料不能为空")]
        public string child_serial { get; set; }
        public double quantity { get; set; }
        public string role { get; set; }
    }

    public class RequestUpdateAssemblyMaintenance : RequestAddAssemblyMaintenance
    {
        [Required(ErrorMessage = "IdNotNull")]
        public int id { get; set; }
    }
}
