﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using Siger.Middlelayer.Repository.Request;

namespace Siger.Middlelayer.AccRepository.Request
{
    public class RequestSN : RequestBase
    {
        [Required(ErrorMessage = "SN不能空")]
        [Description("条形码或唯一码")]
        public string SN { get; set; }

        /// <summary>
        /// 客户接口定义 工站
        /// </summary>
        [Required(ErrorMessage = "sectionid不能空")]
        public int SectionId { get; set; }
        /// <summary>
        /// 兼容老客户端 工站
        /// </summary>
        public int Station { get; set; }
    }

    public class RequestSNList
    {
        [Required(ErrorMessage = "SN不能空")]
        [Description("条形码或唯一码")]
        public string SN { get; set; }

        public int SectionId { get; set; }
    }
    public class RequestAccessories
    {
        public string batch { get; set; }

        public string wo { get; set; }
    }

    public class RequestQueryData
    {
        public string sn { get; set; }
    }
    public class RequestAccess
    {
        public string batch { get; set; }//辅料的序号

        public int  id { get; set; }
        public int number { get; set; }//辅料的数量
        public string name { get; set; }//名称
        /// <summary>
        /// isPart=1 辅料
        /// </summary>
        public int isPart { get; set; }
    }

    public class RequestSingleAccess
    {
        public string sn { get; set; }//辅料的序号

        public int id { get; set; }
        public int number { get; set; }//辅料的数量
        public string name { get; set; }//名称
        /// <summary>
        /// isPart=1 辅料
        /// </summary>
        public int isPart { get; set; }
    }

    public class RequestAssistMaterials:RequestPageBase
    {
        /// <summary>
        /// 产品编号
        /// </summary>
        public string productCode { get; set; }
        /// <summary>
        /// 工单类别
        /// </summary>
        public string woType { get; set; }
        /// <summary>
        /// 工单号
        /// </summary>
        public string wo { get; set; }
        /// <summary>
        /// 品名
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 料号
        /// </summary>
        public string pn { get; set; }
    }
    public class RequestName
    {
        public string name { get; set; }
        public string pn { get; set; }

        public int id { get; set; }
    }

    public class RequestGetName
    {
        public string name { get; set; }
        public string wo { get; set; }
    }
    public class RequestPrint 
    {
        public List<int> ids { get; set; }

        public int type { get; set; }
    }

    public class RequestMaterial
    {
        public int id { get; set; }
        public string workordername { get; set; }
        public string workordertype { get; set; }
    }

    public class RequestMaterials
    {
        public string wo { get; set; }
        public string batch { get; set; }
        public string serial { get; set; }
        public DateTime transdatetime { get; set; }
        public DateTime lastupdatetime { get; set; }
        public string name { get; set; }
        public int number { get; set; }
        public string workordername { get; set; }
        public string productcode { get; set; }
        public string workordertype { get; set; }
        public string woType { get; set; }
        public string specification { get; set; }
        public string pn { get; set; }
        public int printNumber { get; set; }
        public int id{ get; set; }
    }

    public class RequestAssembleBySn : RequestPageBase
    {
        public string ProductId { get; set; }
        public string Pn { get; set; }
        public int Line { get; set; }
        public int Station { get; set; }
        public string OrderNumber { get; set; }
        public string Sn { get; set; }

        public string number { get; set; }
        public int Uid { get; set; }
        public string Result { get; set; }
        public string Box { get; set; }
        public DateTime Starttime { get; set; }
        public DateTime Endtime { get; set; }
        public int ToExcel { get; set; }
    }

    public class RequestAssembleBySnList
    {
        public int id { get; set; }
        public string ProductName { get; set; }
        public string guid { get; set; }
        public string ProductID { get; set; }
        public string Sn { get; set; }
        public string Line { get; set; }
        public string WO { get; set; }
        public string PN { get; set; }
        public string ResultStatus { get; set; }
        public DateTime InputDateTime { get; set; }
        public DateTime TransDateTime { get; set; }
        public string parentSN { get; set; }
        public string visualSN { get; set; }
        public int machineid { get; set; }
        public int station { get; set; }
        public string uid { get; set; }
        public int status { get; set; }
        public string productname { get; set; }
        public string productdraw { get; set; }
    }

    public class RequestAssembleData : RequestPageBase
    {
        public string ProductId { get; set; }
        public string Pn { get; set; }
        public int Line { get; set; }
        public int Station { get; set; }
        public string OrderNumber { get; set; }
        public string Sn { get; set; }

        public string number { get; set; }
        public int Uid { get; set; }
        public string Result { get; set; }
        public string Box { get; set; }
        public DateTime DtStart { get; set; }
        public DateTime DtEnd { get; set; }
    }
}
