﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using Siger.Middlelayer.Repository.Request;

namespace Siger.Middlelayer.AccRepository.Request
{
    public class RequestTraceDetails : RequestBase
    {
        public string SeqID { get; set; }
        [Required(ErrorMessage = "SN 不能空")]
        public string SN { get; set; }
        [Required(ErrorMessage = "Item 不能空")]
        public string Item { get; set; }
        [Required(ErrorMessage = "Value 不能空")]
        public string Value { get; set; }
        [Required(ErrorMessage = "Result 不能空")]
        public string Result { get; set; }
        [Required(ErrorMessage = "TransDateTime 不能空")]
        public DateTime TransDateTime { get; set; }
    }
    public class RequestTraceDetailsList : RequestBase
    {
        [Required(ErrorMessage = "SN 不能空")]
        public string SN { get; set; }
        public string Result { get; set; }
        public int SectionID { get; set; }
        /// <summary>
        /// 兼容老客户端
        /// </summary>
        public int Station { get; set; }
        public List<TraceDetails> Details { get; set; }

        public int companyId { get; set; } = 160;

        public int projectId { get; set; } = 160;
    }
    public class TraceDetails
    {
        /// <summary>
        /// OQC.id
        /// </summary>
        public int ItemId { get; set; }
        [Required(ErrorMessage = "Item 不能空")]
        public string Item { get; set; }
        [Required(ErrorMessage = "Value 不能空")]
        public string Value { get; set; }
        public string Result { get; set; }

        // public DateTime TransDateTime { get; set; }
    }

    public class TFTrace : RequestTraceDetailsList
    {
        [Required(ErrorMessage = "username 不能空")]

        public string username { get; set; }
    }
    public class  Requseciuit:RequestBase
    {
        public string SeqID { get; set; }
        public string SN { get; set; }
        [Required(ErrorMessage = "Result 不能空")]
        public string Result { get; set; }
        [Required(ErrorMessage = "TransDateTime 不能空")]
        public DateTime TransDateTime { get; set; }
        public List<TraceDetails> Details { get; set; }
    }
}
